/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bcmdataexports.model.Table;
import java.util.List;

@SdkInternalApi
public class TableMarshaller {
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<List> TABLEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableProperties").build();
    private static final TableMarshaller instance = new TableMarshaller();

    public static TableMarshaller getInstance() {
        return instance;
    }

    public void marshall(Table table, ProtocolMarshaller protocolMarshaller) {
        if (table == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)table.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)table.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(table.getTableProperties(), TABLEPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

