/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bcmdataexports.model.S3OutputConfigurations;

@SdkInternalApi
public class S3OutputConfigurationsMarshaller {
    private static final MarshallingInfo<String> COMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compression").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").build();
    private static final MarshallingInfo<String> OUTPUTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputType").build();
    private static final MarshallingInfo<String> OVERWRITE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Overwrite").build();
    private static final S3OutputConfigurationsMarshaller instance = new S3OutputConfigurationsMarshaller();

    public static S3OutputConfigurationsMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3OutputConfigurations s3OutputConfigurations, ProtocolMarshaller protocolMarshaller) {
        if (s3OutputConfigurations == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3OutputConfigurations.getCompression(), COMPRESSION_BINDING);
            protocolMarshaller.marshall((Object)s3OutputConfigurations.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3OutputConfigurations.getOutputType(), OUTPUTTYPE_BINDING);
            protocolMarshaller.marshall((Object)s3OutputConfigurations.getOverwrite(), OVERWRITE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

