/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.ShareAttributes;
import com.amazonaws.services.batch.model.transform.FairsharePolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FairsharePolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer shareDecaySeconds;
    private Integer computeReservation;
    private List<ShareAttributes> shareDistribution;

    public void setShareDecaySeconds(Integer shareDecaySeconds) {
        this.shareDecaySeconds = shareDecaySeconds;
    }

    public Integer getShareDecaySeconds() {
        return this.shareDecaySeconds;
    }

    public FairsharePolicy withShareDecaySeconds(Integer shareDecaySeconds) {
        this.setShareDecaySeconds(shareDecaySeconds);
        return this;
    }

    public void setComputeReservation(Integer computeReservation) {
        this.computeReservation = computeReservation;
    }

    public Integer getComputeReservation() {
        return this.computeReservation;
    }

    public FairsharePolicy withComputeReservation(Integer computeReservation) {
        this.setComputeReservation(computeReservation);
        return this;
    }

    public List<ShareAttributes> getShareDistribution() {
        return this.shareDistribution;
    }

    public void setShareDistribution(Collection<ShareAttributes> shareDistribution) {
        if (shareDistribution == null) {
            this.shareDistribution = null;
            return;
        }
        this.shareDistribution = new ArrayList<ShareAttributes>(shareDistribution);
    }

    public FairsharePolicy withShareDistribution(ShareAttributes ... shareDistribution) {
        if (this.shareDistribution == null) {
            this.setShareDistribution(new ArrayList<ShareAttributes>(shareDistribution.length));
        }
        for (ShareAttributes ele : shareDistribution) {
            this.shareDistribution.add(ele);
        }
        return this;
    }

    public FairsharePolicy withShareDistribution(Collection<ShareAttributes> shareDistribution) {
        this.setShareDistribution(shareDistribution);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getShareDecaySeconds() != null) {
            sb.append("ShareDecaySeconds: ").append(this.getShareDecaySeconds()).append(",");
        }
        if (this.getComputeReservation() != null) {
            sb.append("ComputeReservation: ").append(this.getComputeReservation()).append(",");
        }
        if (this.getShareDistribution() != null) {
            sb.append("ShareDistribution: ").append(this.getShareDistribution());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FairsharePolicy)) {
            return false;
        }
        FairsharePolicy other = (FairsharePolicy)obj;
        if (other.getShareDecaySeconds() == null ^ this.getShareDecaySeconds() == null) {
            return false;
        }
        if (other.getShareDecaySeconds() != null && !other.getShareDecaySeconds().equals(this.getShareDecaySeconds())) {
            return false;
        }
        if (other.getComputeReservation() == null ^ this.getComputeReservation() == null) {
            return false;
        }
        if (other.getComputeReservation() != null && !other.getComputeReservation().equals(this.getComputeReservation())) {
            return false;
        }
        if (other.getShareDistribution() == null ^ this.getShareDistribution() == null) {
            return false;
        }
        return other.getShareDistribution() == null || other.getShareDistribution().equals(this.getShareDistribution());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getShareDecaySeconds() == null ? 0 : this.getShareDecaySeconds().hashCode());
        hashCode = 31 * hashCode + (this.getComputeReservation() == null ? 0 : this.getComputeReservation().hashCode());
        hashCode = 31 * hashCode + (this.getShareDistribution() == null ? 0 : this.getShareDistribution().hashCode());
        return hashCode;
    }

    public FairsharePolicy clone() {
        try {
            return (FairsharePolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FairsharePolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

