/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.batch.model.EksSecret;

@SdkInternalApi
public class EksSecretMarshaller {
    private static final MarshallingInfo<String> SECRETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretName").build();
    private static final MarshallingInfo<Boolean> OPTIONAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("optional").build();
    private static final EksSecretMarshaller instance = new EksSecretMarshaller();

    public static EksSecretMarshaller getInstance() {
        return instance;
    }

    public void marshall(EksSecret eksSecret, ProtocolMarshaller protocolMarshaller) {
        if (eksSecret == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eksSecret.getSecretName(), SECRETNAME_BINDING);
            protocolMarshaller.marshall((Object)eksSecret.getOptional(), OPTIONAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

