/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.batch.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object that represents a job timeout configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobTimeout" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class JobTimeout implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp. After
     * this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60
     * seconds.
     * </p>
     * <p>
     * For array jobs, the timeout applies to the child jobs, not to the parent array job.
     * </p>
     * <p>
     * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     * </p>
     */
    private Integer attemptDurationSeconds;

    /**
     * <p>
     * The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp. After
     * this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60
     * seconds.
     * </p>
     * <p>
     * For array jobs, the timeout applies to the child jobs, not to the parent array job.
     * </p>
     * <p>
     * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     * </p>
     * 
     * @param attemptDurationSeconds
     *        The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp.
     *        After this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the
     *        timeout is 60 seconds.</p>
     *        <p>
     *        For array jobs, the timeout applies to the child jobs, not to the parent array job.
     *        </p>
     *        <p>
     *        For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     */

    public void setAttemptDurationSeconds(Integer attemptDurationSeconds) {
        this.attemptDurationSeconds = attemptDurationSeconds;
    }

    /**
     * <p>
     * The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp. After
     * this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60
     * seconds.
     * </p>
     * <p>
     * For array jobs, the timeout applies to the child jobs, not to the parent array job.
     * </p>
     * <p>
     * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     * </p>
     * 
     * @return The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code>
     *         timestamp. After this time passes, Batch terminates your jobs if they aren't finished. The minimum value
     *         for the timeout is 60 seconds.</p>
     *         <p>
     *         For array jobs, the timeout applies to the child jobs, not to the parent array job.
     *         </p>
     *         <p>
     *         For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     */

    public Integer getAttemptDurationSeconds() {
        return this.attemptDurationSeconds;
    }

    /**
     * <p>
     * The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp. After
     * this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60
     * seconds.
     * </p>
     * <p>
     * For array jobs, the timeout applies to the child jobs, not to the parent array job.
     * </p>
     * <p>
     * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     * </p>
     * 
     * @param attemptDurationSeconds
     *        The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp.
     *        After this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the
     *        timeout is 60 seconds.</p>
     *        <p>
     *        For array jobs, the timeout applies to the child jobs, not to the parent array job.
     *        </p>
     *        <p>
     *        For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobTimeout withAttemptDurationSeconds(Integer attemptDurationSeconds) {
        setAttemptDurationSeconds(attemptDurationSeconds);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAttemptDurationSeconds() != null)
            sb.append("AttemptDurationSeconds: ").append(getAttemptDurationSeconds());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof JobTimeout == false)
            return false;
        JobTimeout other = (JobTimeout) obj;
        if (other.getAttemptDurationSeconds() == null ^ this.getAttemptDurationSeconds() == null)
            return false;
        if (other.getAttemptDurationSeconds() != null && other.getAttemptDurationSeconds().equals(this.getAttemptDurationSeconds()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAttemptDurationSeconds() == null) ? 0 : getAttemptDurationSeconds().hashCode());
        return hashCode;
    }

    @Override
    public JobTimeout clone() {
        try {
            return (JobTimeout) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.batch.model.transform.JobTimeoutMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
