/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.batch.model.Ec2Configuration;

@SdkInternalApi
public class Ec2ConfigurationMarshaller {
    private static final MarshallingInfo<String> IMAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageType").build();
    private static final MarshallingInfo<String> IMAGEIDOVERRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageIdOverride").build();
    private static final Ec2ConfigurationMarshaller instance = new Ec2ConfigurationMarshaller();

    public static Ec2ConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Ec2Configuration ec2Configuration, ProtocolMarshaller protocolMarshaller) {
        if (ec2Configuration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ec2Configuration.getImageType(), IMAGETYPE_BINDING);
            protocolMarshaller.marshall((Object)ec2Configuration.getImageIdOverride(), IMAGEIDOVERRIDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

