/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.Volume;
import com.amazonaws.services.batch.model.transform.HostJsonMarshaller;

public class VolumeJsonMarshaller {
    private static VolumeJsonMarshaller instance;

    public void marshall(Volume volume, StructuredJsonGenerator jsonGenerator) {
        if (volume == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (volume.getHost() != null) {
                jsonGenerator.writeFieldName("host");
                HostJsonMarshaller.getInstance().marshall(volume.getHost(), jsonGenerator);
            }
            if (volume.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(volume.getName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VolumeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VolumeJsonMarshaller();
        }
        return instance;
    }
}

