/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.DescribeComputeEnvironmentsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeComputeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeComputeEnvironmentsRequest>, DescribeComputeEnvironmentsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeComputeEnvironmentsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeComputeEnvironmentsRequest> marshall(DescribeComputeEnvironmentsRequest describeComputeEnvironmentsRequest) {
        if (describeComputeEnvironmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeComputeEnvironmentsRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/describecomputeenvironments";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> computeEnvironmentsList = describeComputeEnvironmentsRequest.getComputeEnvironments();
            if (computeEnvironmentsList != null) {
                jsonGenerator.writeFieldName("computeEnvironments");
                jsonGenerator.writeStartArray();
                for (String computeEnvironmentsListValue : computeEnvironmentsList) {
                    if (computeEnvironmentsListValue == null) continue;
                    jsonGenerator.writeValue(computeEnvironmentsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeComputeEnvironmentsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeComputeEnvironmentsRequest.getMaxResults().intValue());
            }
            if (describeComputeEnvironmentsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeComputeEnvironmentsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

