/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.JobDependency;
import com.amazonaws.services.batch.model.SubmitJobRequest;
import com.amazonaws.services.batch.model.transform.ContainerOverridesJsonMarshaller;
import com.amazonaws.services.batch.model.transform.JobDependencyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class SubmitJobRequestMarshaller
implements Marshaller<Request<SubmitJobRequest>, SubmitJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SubmitJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SubmitJobRequest> marshall(SubmitJobRequest submitJobRequest) {
        if (submitJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)submitJobRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/submitjob";
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> parametersMap;
            List<JobDependency> dependsOnList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (submitJobRequest.getJobName() != null) {
                jsonGenerator.writeFieldName("jobName").writeValue(submitJobRequest.getJobName());
            }
            if (submitJobRequest.getJobQueue() != null) {
                jsonGenerator.writeFieldName("jobQueue").writeValue(submitJobRequest.getJobQueue());
            }
            if ((dependsOnList = submitJobRequest.getDependsOn()) != null) {
                jsonGenerator.writeFieldName("dependsOn");
                jsonGenerator.writeStartArray();
                for (JobDependency jobDependency : dependsOnList) {
                    if (jobDependency == null) continue;
                    JobDependencyJsonMarshaller.getInstance().marshall(jobDependency, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (submitJobRequest.getJobDefinition() != null) {
                jsonGenerator.writeFieldName("jobDefinition").writeValue(submitJobRequest.getJobDefinition());
            }
            if ((parametersMap = submitJobRequest.getParameters()) != null) {
                jsonGenerator.writeFieldName("parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> entry : parametersMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    jsonGenerator.writeValue(entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (submitJobRequest.getContainerOverrides() != null) {
                jsonGenerator.writeFieldName("containerOverrides");
                ContainerOverridesJsonMarshaller.getInstance().marshall(submitJobRequest.getContainerOverrides(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

