/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.batch.AWSBatchAsync;
import com.amazonaws.services.batch.AWSBatchAsyncClientBuilder;
import com.amazonaws.services.batch.AWSBatchClient;
import com.amazonaws.services.batch.model.CancelJobRequest;
import com.amazonaws.services.batch.model.CancelJobResult;
import com.amazonaws.services.batch.model.CreateComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.CreateComputeEnvironmentResult;
import com.amazonaws.services.batch.model.CreateJobQueueRequest;
import com.amazonaws.services.batch.model.CreateJobQueueResult;
import com.amazonaws.services.batch.model.DeleteComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.DeleteComputeEnvironmentResult;
import com.amazonaws.services.batch.model.DeleteJobQueueRequest;
import com.amazonaws.services.batch.model.DeleteJobQueueResult;
import com.amazonaws.services.batch.model.DeregisterJobDefinitionRequest;
import com.amazonaws.services.batch.model.DeregisterJobDefinitionResult;
import com.amazonaws.services.batch.model.DescribeComputeEnvironmentsRequest;
import com.amazonaws.services.batch.model.DescribeComputeEnvironmentsResult;
import com.amazonaws.services.batch.model.DescribeJobDefinitionsRequest;
import com.amazonaws.services.batch.model.DescribeJobDefinitionsResult;
import com.amazonaws.services.batch.model.DescribeJobQueuesRequest;
import com.amazonaws.services.batch.model.DescribeJobQueuesResult;
import com.amazonaws.services.batch.model.DescribeJobsRequest;
import com.amazonaws.services.batch.model.DescribeJobsResult;
import com.amazonaws.services.batch.model.ListJobsRequest;
import com.amazonaws.services.batch.model.ListJobsResult;
import com.amazonaws.services.batch.model.ListTagsForResourceRequest;
import com.amazonaws.services.batch.model.ListTagsForResourceResult;
import com.amazonaws.services.batch.model.RegisterJobDefinitionRequest;
import com.amazonaws.services.batch.model.RegisterJobDefinitionResult;
import com.amazonaws.services.batch.model.SubmitJobRequest;
import com.amazonaws.services.batch.model.SubmitJobResult;
import com.amazonaws.services.batch.model.TagResourceRequest;
import com.amazonaws.services.batch.model.TagResourceResult;
import com.amazonaws.services.batch.model.TerminateJobRequest;
import com.amazonaws.services.batch.model.TerminateJobResult;
import com.amazonaws.services.batch.model.UntagResourceRequest;
import com.amazonaws.services.batch.model.UntagResourceResult;
import com.amazonaws.services.batch.model.UpdateComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.UpdateComputeEnvironmentResult;
import com.amazonaws.services.batch.model.UpdateJobQueueRequest;
import com.amazonaws.services.batch.model.UpdateJobQueueResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBatchAsyncClient
extends AWSBatchClient
implements AWSBatchAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSBatchAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSBatchAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSBatchAsyncClientBuilder asyncBuilder() {
        return AWSBatchAsyncClientBuilder.standard();
    }

    AWSBatchAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSBatchAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        final CancelJobRequest finalRequest = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeCancelJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateComputeEnvironmentResult> createComputeEnvironmentAsync(CreateComputeEnvironmentRequest request) {
        return this.createComputeEnvironmentAsync(request, null);
    }

    @Override
    public Future<CreateComputeEnvironmentResult> createComputeEnvironmentAsync(CreateComputeEnvironmentRequest request, final AsyncHandler<CreateComputeEnvironmentRequest, CreateComputeEnvironmentResult> asyncHandler) {
        final CreateComputeEnvironmentRequest finalRequest = (CreateComputeEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateComputeEnvironmentResult>(){

            @Override
            public CreateComputeEnvironmentResult call() throws Exception {
                CreateComputeEnvironmentResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeCreateComputeEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobQueueResult> createJobQueueAsync(CreateJobQueueRequest request) {
        return this.createJobQueueAsync(request, null);
    }

    @Override
    public Future<CreateJobQueueResult> createJobQueueAsync(CreateJobQueueRequest request, final AsyncHandler<CreateJobQueueRequest, CreateJobQueueResult> asyncHandler) {
        final CreateJobQueueRequest finalRequest = (CreateJobQueueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobQueueResult>(){

            @Override
            public CreateJobQueueResult call() throws Exception {
                CreateJobQueueResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeCreateJobQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteComputeEnvironmentResult> deleteComputeEnvironmentAsync(DeleteComputeEnvironmentRequest request) {
        return this.deleteComputeEnvironmentAsync(request, null);
    }

    @Override
    public Future<DeleteComputeEnvironmentResult> deleteComputeEnvironmentAsync(DeleteComputeEnvironmentRequest request, final AsyncHandler<DeleteComputeEnvironmentRequest, DeleteComputeEnvironmentResult> asyncHandler) {
        final DeleteComputeEnvironmentRequest finalRequest = (DeleteComputeEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteComputeEnvironmentResult>(){

            @Override
            public DeleteComputeEnvironmentResult call() throws Exception {
                DeleteComputeEnvironmentResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeDeleteComputeEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteJobQueueResult> deleteJobQueueAsync(DeleteJobQueueRequest request) {
        return this.deleteJobQueueAsync(request, null);
    }

    @Override
    public Future<DeleteJobQueueResult> deleteJobQueueAsync(DeleteJobQueueRequest request, final AsyncHandler<DeleteJobQueueRequest, DeleteJobQueueResult> asyncHandler) {
        final DeleteJobQueueRequest finalRequest = (DeleteJobQueueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteJobQueueResult>(){

            @Override
            public DeleteJobQueueResult call() throws Exception {
                DeleteJobQueueResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeDeleteJobQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterJobDefinitionResult> deregisterJobDefinitionAsync(DeregisterJobDefinitionRequest request) {
        return this.deregisterJobDefinitionAsync(request, null);
    }

    @Override
    public Future<DeregisterJobDefinitionResult> deregisterJobDefinitionAsync(DeregisterJobDefinitionRequest request, final AsyncHandler<DeregisterJobDefinitionRequest, DeregisterJobDefinitionResult> asyncHandler) {
        final DeregisterJobDefinitionRequest finalRequest = (DeregisterJobDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterJobDefinitionResult>(){

            @Override
            public DeregisterJobDefinitionResult call() throws Exception {
                DeregisterJobDefinitionResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeDeregisterJobDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComputeEnvironmentsResult> describeComputeEnvironmentsAsync(DescribeComputeEnvironmentsRequest request) {
        return this.describeComputeEnvironmentsAsync(request, null);
    }

    @Override
    public Future<DescribeComputeEnvironmentsResult> describeComputeEnvironmentsAsync(DescribeComputeEnvironmentsRequest request, final AsyncHandler<DescribeComputeEnvironmentsRequest, DescribeComputeEnvironmentsResult> asyncHandler) {
        final DescribeComputeEnvironmentsRequest finalRequest = (DescribeComputeEnvironmentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeComputeEnvironmentsResult>(){

            @Override
            public DescribeComputeEnvironmentsResult call() throws Exception {
                DescribeComputeEnvironmentsResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeDescribeComputeEnvironments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobDefinitionsResult> describeJobDefinitionsAsync(DescribeJobDefinitionsRequest request) {
        return this.describeJobDefinitionsAsync(request, null);
    }

    @Override
    public Future<DescribeJobDefinitionsResult> describeJobDefinitionsAsync(DescribeJobDefinitionsRequest request, final AsyncHandler<DescribeJobDefinitionsRequest, DescribeJobDefinitionsResult> asyncHandler) {
        final DescribeJobDefinitionsRequest finalRequest = (DescribeJobDefinitionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobDefinitionsResult>(){

            @Override
            public DescribeJobDefinitionsResult call() throws Exception {
                DescribeJobDefinitionsResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeDescribeJobDefinitions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobQueuesResult> describeJobQueuesAsync(DescribeJobQueuesRequest request) {
        return this.describeJobQueuesAsync(request, null);
    }

    @Override
    public Future<DescribeJobQueuesResult> describeJobQueuesAsync(DescribeJobQueuesRequest request, final AsyncHandler<DescribeJobQueuesRequest, DescribeJobQueuesResult> asyncHandler) {
        final DescribeJobQueuesRequest finalRequest = (DescribeJobQueuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobQueuesResult>(){

            @Override
            public DescribeJobQueuesResult call() throws Exception {
                DescribeJobQueuesResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeDescribeJobQueues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobsResult> describeJobsAsync(DescribeJobsRequest request) {
        return this.describeJobsAsync(request, null);
    }

    @Override
    public Future<DescribeJobsResult> describeJobsAsync(DescribeJobsRequest request, final AsyncHandler<DescribeJobsRequest, DescribeJobsResult> asyncHandler) {
        final DescribeJobsRequest finalRequest = (DescribeJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobsResult>(){

            @Override
            public DescribeJobsResult call() throws Exception {
                DescribeJobsResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeDescribeJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        final ListJobsRequest finalRequest = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeListJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterJobDefinitionResult> registerJobDefinitionAsync(RegisterJobDefinitionRequest request) {
        return this.registerJobDefinitionAsync(request, null);
    }

    @Override
    public Future<RegisterJobDefinitionResult> registerJobDefinitionAsync(RegisterJobDefinitionRequest request, final AsyncHandler<RegisterJobDefinitionRequest, RegisterJobDefinitionResult> asyncHandler) {
        final RegisterJobDefinitionRequest finalRequest = (RegisterJobDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterJobDefinitionResult>(){

            @Override
            public RegisterJobDefinitionResult call() throws Exception {
                RegisterJobDefinitionResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeRegisterJobDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubmitJobResult> submitJobAsync(SubmitJobRequest request) {
        return this.submitJobAsync(request, null);
    }

    @Override
    public Future<SubmitJobResult> submitJobAsync(SubmitJobRequest request, final AsyncHandler<SubmitJobRequest, SubmitJobResult> asyncHandler) {
        final SubmitJobRequest finalRequest = (SubmitJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SubmitJobResult>(){

            @Override
            public SubmitJobResult call() throws Exception {
                SubmitJobResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeSubmitJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateJobResult> terminateJobAsync(TerminateJobRequest request) {
        return this.terminateJobAsync(request, null);
    }

    @Override
    public Future<TerminateJobResult> terminateJobAsync(TerminateJobRequest request, final AsyncHandler<TerminateJobRequest, TerminateJobResult> asyncHandler) {
        final TerminateJobRequest finalRequest = (TerminateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TerminateJobResult>(){

            @Override
            public TerminateJobResult call() throws Exception {
                TerminateJobResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeTerminateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateComputeEnvironmentResult> updateComputeEnvironmentAsync(UpdateComputeEnvironmentRequest request) {
        return this.updateComputeEnvironmentAsync(request, null);
    }

    @Override
    public Future<UpdateComputeEnvironmentResult> updateComputeEnvironmentAsync(UpdateComputeEnvironmentRequest request, final AsyncHandler<UpdateComputeEnvironmentRequest, UpdateComputeEnvironmentResult> asyncHandler) {
        final UpdateComputeEnvironmentRequest finalRequest = (UpdateComputeEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateComputeEnvironmentResult>(){

            @Override
            public UpdateComputeEnvironmentResult call() throws Exception {
                UpdateComputeEnvironmentResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeUpdateComputeEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobQueueResult> updateJobQueueAsync(UpdateJobQueueRequest request) {
        return this.updateJobQueueAsync(request, null);
    }

    @Override
    public Future<UpdateJobQueueResult> updateJobQueueAsync(UpdateJobQueueRequest request, final AsyncHandler<UpdateJobQueueRequest, UpdateJobQueueResult> asyncHandler) {
        final UpdateJobQueueRequest finalRequest = (UpdateJobQueueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateJobQueueResult>(){

            @Override
            public UpdateJobQueueResult call() throws Exception {
                UpdateJobQueueResult result = null;
                try {
                    result = AWSBatchAsyncClient.this.executeUpdateJobQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

