/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.backup.model.Framework;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFrameworksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Framework> frameworks;
    private String nextToken;

    public List<Framework> getFrameworks() {
        return this.frameworks;
    }

    public void setFrameworks(Collection<Framework> frameworks) {
        if (frameworks == null) {
            this.frameworks = null;
            return;
        }
        this.frameworks = new ArrayList<Framework>(frameworks);
    }

    public ListFrameworksResult withFrameworks(Framework ... frameworks) {
        if (this.frameworks == null) {
            this.setFrameworks(new ArrayList<Framework>(frameworks.length));
        }
        for (Framework ele : frameworks) {
            this.frameworks.add(ele);
        }
        return this;
    }

    public ListFrameworksResult withFrameworks(Collection<Framework> frameworks) {
        this.setFrameworks(frameworks);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFrameworksResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrameworks() != null) {
            sb.append("Frameworks: ").append(this.getFrameworks()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFrameworksResult)) {
            return false;
        }
        ListFrameworksResult other = (ListFrameworksResult)obj;
        if (other.getFrameworks() == null ^ this.getFrameworks() == null) {
            return false;
        }
        if (other.getFrameworks() != null && !other.getFrameworks().equals(this.getFrameworks())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrameworks() == null ? 0 : this.getFrameworks().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListFrameworksResult clone() {
        try {
            return (ListFrameworksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

