/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.transform.AdvancedBackupSettingMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AdvancedBackupSetting
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceType;
    private Map<String, String> backupOptions;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public AdvancedBackupSetting withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public Map<String, String> getBackupOptions() {
        return this.backupOptions;
    }

    public void setBackupOptions(Map<String, String> backupOptions) {
        this.backupOptions = backupOptions;
    }

    public AdvancedBackupSetting withBackupOptions(Map<String, String> backupOptions) {
        this.setBackupOptions(backupOptions);
        return this;
    }

    public AdvancedBackupSetting addBackupOptionsEntry(String key, String value) {
        if (null == this.backupOptions) {
            this.backupOptions = new HashMap<String, String>();
        }
        if (this.backupOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.backupOptions.put(key, value);
        return this;
    }

    public AdvancedBackupSetting clearBackupOptionsEntries() {
        this.backupOptions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getBackupOptions() != null) {
            sb.append("BackupOptions: ").append(this.getBackupOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedBackupSetting)) {
            return false;
        }
        AdvancedBackupSetting other = (AdvancedBackupSetting)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getBackupOptions() == null ^ this.getBackupOptions() == null) {
            return false;
        }
        return other.getBackupOptions() == null || other.getBackupOptions().equals(this.getBackupOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getBackupOptions() == null ? 0 : this.getBackupOptions().hashCode());
        return hashCode;
    }

    public AdvancedBackupSetting clone() {
        try {
            return (AdvancedBackupSetting)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdvancedBackupSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

