/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.b2bi.model.CapabilitySummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCapabilitiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<CapabilitySummary> capabilities;
    private String nextToken;

    public List<CapabilitySummary> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<CapabilitySummary> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new ArrayList<CapabilitySummary>(capabilities);
    }

    public ListCapabilitiesResult withCapabilities(CapabilitySummary ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new ArrayList<CapabilitySummary>(capabilities.length));
        }
        for (CapabilitySummary ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public ListCapabilitiesResult withCapabilities(Collection<CapabilitySummary> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCapabilitiesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapabilitiesResult)) {
            return false;
        }
        ListCapabilitiesResult other = (ListCapabilitiesResult)obj;
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListCapabilitiesResult clone() {
        try {
            return (ListCapabilitiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

