/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import com.amazonaws.services.autoscaling.model.ScheduledUpdateGroupActionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class BatchPutScheduledUpdateGroupActionRequestMarshaller
implements Marshaller<Request<BatchPutScheduledUpdateGroupActionRequest>, BatchPutScheduledUpdateGroupActionRequest> {
    public Request<BatchPutScheduledUpdateGroupActionRequest> marshall(BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) {
        if (batchPutScheduledUpdateGroupActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchPutScheduledUpdateGroupActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "BatchPutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchPutScheduledUpdateGroupActionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)batchPutScheduledUpdateGroupActionRequest.getAutoScalingGroupName()));
        }
        if (!batchPutScheduledUpdateGroupActionRequest.getScheduledUpdateGroupActions().isEmpty() || !((SdkInternalList)batchPutScheduledUpdateGroupActionRequest.getScheduledUpdateGroupActions()).isAutoConstruct()) {
            SdkInternalList scheduledUpdateGroupActionsList = (SdkInternalList)batchPutScheduledUpdateGroupActionRequest.getScheduledUpdateGroupActions();
            int scheduledUpdateGroupActionsListIndex = 1;
            for (ScheduledUpdateGroupActionRequest scheduledUpdateGroupActionsListValue : scheduledUpdateGroupActionsList) {
                if (scheduledUpdateGroupActionsListValue != null) {
                    if (scheduledUpdateGroupActionsListValue.getScheduledActionName() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".ScheduledActionName", StringUtils.fromString((String)scheduledUpdateGroupActionsListValue.getScheduledActionName()));
                    }
                    if (scheduledUpdateGroupActionsListValue.getStartTime() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".StartTime", StringUtils.fromDate((Date)scheduledUpdateGroupActionsListValue.getStartTime()));
                    }
                    if (scheduledUpdateGroupActionsListValue.getEndTime() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".EndTime", StringUtils.fromDate((Date)scheduledUpdateGroupActionsListValue.getEndTime()));
                    }
                    if (scheduledUpdateGroupActionsListValue.getRecurrence() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".Recurrence", StringUtils.fromString((String)scheduledUpdateGroupActionsListValue.getRecurrence()));
                    }
                    if (scheduledUpdateGroupActionsListValue.getMinSize() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".MinSize", StringUtils.fromInteger((Integer)scheduledUpdateGroupActionsListValue.getMinSize()));
                    }
                    if (scheduledUpdateGroupActionsListValue.getMaxSize() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".MaxSize", StringUtils.fromInteger((Integer)scheduledUpdateGroupActionsListValue.getMaxSize()));
                    }
                    if (scheduledUpdateGroupActionsListValue.getDesiredCapacity() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".DesiredCapacity", StringUtils.fromInteger((Integer)scheduledUpdateGroupActionsListValue.getDesiredCapacity()));
                    }
                    if (scheduledUpdateGroupActionsListValue.getTimeZone() != null) {
                        request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".TimeZone", StringUtils.fromString((String)scheduledUpdateGroupActionsListValue.getTimeZone()));
                    }
                }
                ++scheduledUpdateGroupActionsListIndex;
            }
        }
        return request;
    }
}

