/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.autoscaling.model.InstanceReusePolicy;
import com.amazonaws.services.autoscaling.model.PutWarmPoolRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutWarmPoolRequestMarshaller
implements Marshaller<Request<PutWarmPoolRequest>, PutWarmPoolRequest> {
    public Request<PutWarmPoolRequest> marshall(PutWarmPoolRequest putWarmPoolRequest) {
        InstanceReusePolicy instanceReusePolicy;
        if (putWarmPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putWarmPoolRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutWarmPool");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putWarmPoolRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putWarmPoolRequest.getAutoScalingGroupName()));
        }
        if (putWarmPoolRequest.getMaxGroupPreparedCapacity() != null) {
            request.addParameter("MaxGroupPreparedCapacity", StringUtils.fromInteger((Integer)putWarmPoolRequest.getMaxGroupPreparedCapacity()));
        }
        if (putWarmPoolRequest.getMinSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)putWarmPoolRequest.getMinSize()));
        }
        if (putWarmPoolRequest.getPoolState() != null) {
            request.addParameter("PoolState", StringUtils.fromString((String)putWarmPoolRequest.getPoolState()));
        }
        if ((instanceReusePolicy = putWarmPoolRequest.getInstanceReusePolicy()) != null && instanceReusePolicy.getReuseOnScaleIn() != null) {
            request.addParameter("InstanceReusePolicy.ReuseOnScaleIn", StringUtils.fromBoolean((Boolean)instanceReusePolicy.getReuseOnScaleIn()));
        }
        return request;
    }
}

