/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.LoadForecast;
import com.amazonaws.services.autoscaling.model.transform.PredictiveScalingMetricSpecificationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.stream.events.XMLEvent;

public class LoadForecastStaxUnmarshaller
implements Unmarshaller<LoadForecast, StaxUnmarshallerContext> {
    private static LoadForecastStaxUnmarshaller instance;

    public LoadForecast unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoadForecast loadForecast = new LoadForecast();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return loadForecast;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Timestamps", targetDepth)) {
                    loadForecast.withTimestamps(new ArrayList<Date>());
                    continue;
                }
                if (context.testExpression("Timestamps/member", targetDepth)) {
                    loadForecast.withTimestamps(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Values", targetDepth)) {
                    loadForecast.withValues(new ArrayList<Double>());
                    continue;
                }
                if (context.testExpression("Values/member", targetDepth)) {
                    loadForecast.withValues(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MetricSpecification", targetDepth)) continue;
                loadForecast.setMetricSpecification(PredictiveScalingMetricSpecificationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return loadForecast;
    }

    public static LoadForecastStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LoadForecastStaxUnmarshaller();
        }
        return instance;
    }
}

