/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.AcceleratorCountRequest;
import com.amazonaws.services.autoscaling.model.AcceleratorManufacturer;
import com.amazonaws.services.autoscaling.model.AcceleratorName;
import com.amazonaws.services.autoscaling.model.AcceleratorTotalMemoryMiBRequest;
import com.amazonaws.services.autoscaling.model.AcceleratorType;
import com.amazonaws.services.autoscaling.model.BareMetal;
import com.amazonaws.services.autoscaling.model.BaselineEbsBandwidthMbpsRequest;
import com.amazonaws.services.autoscaling.model.BurstablePerformance;
import com.amazonaws.services.autoscaling.model.CpuManufacturer;
import com.amazonaws.services.autoscaling.model.InstanceGeneration;
import com.amazonaws.services.autoscaling.model.LocalStorage;
import com.amazonaws.services.autoscaling.model.LocalStorageType;
import com.amazonaws.services.autoscaling.model.MemoryGiBPerVCpuRequest;
import com.amazonaws.services.autoscaling.model.MemoryMiBRequest;
import com.amazonaws.services.autoscaling.model.NetworkBandwidthGbpsRequest;
import com.amazonaws.services.autoscaling.model.NetworkInterfaceCountRequest;
import com.amazonaws.services.autoscaling.model.TotalLocalStorageGBRequest;
import com.amazonaws.services.autoscaling.model.VCpuCountRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceRequirements
implements Serializable,
Cloneable {
    private VCpuCountRequest vCpuCount;
    private MemoryMiBRequest memoryMiB;
    private SdkInternalList<String> cpuManufacturers;
    private MemoryGiBPerVCpuRequest memoryGiBPerVCpu;
    private SdkInternalList<String> excludedInstanceTypes;
    private SdkInternalList<String> instanceGenerations;
    private Integer spotMaxPricePercentageOverLowestPrice;
    private Integer maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
    private Integer onDemandMaxPricePercentageOverLowestPrice;
    private String bareMetal;
    private String burstablePerformance;
    private Boolean requireHibernateSupport;
    private NetworkInterfaceCountRequest networkInterfaceCount;
    private String localStorage;
    private SdkInternalList<String> localStorageTypes;
    private TotalLocalStorageGBRequest totalLocalStorageGB;
    private BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps;
    private SdkInternalList<String> acceleratorTypes;
    private AcceleratorCountRequest acceleratorCount;
    private SdkInternalList<String> acceleratorManufacturers;
    private SdkInternalList<String> acceleratorNames;
    private AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB;
    private NetworkBandwidthGbpsRequest networkBandwidthGbps;
    private SdkInternalList<String> allowedInstanceTypes;

    public void setVCpuCount(VCpuCountRequest vCpuCount) {
        this.vCpuCount = vCpuCount;
    }

    public VCpuCountRequest getVCpuCount() {
        return this.vCpuCount;
    }

    public InstanceRequirements withVCpuCount(VCpuCountRequest vCpuCount) {
        this.setVCpuCount(vCpuCount);
        return this;
    }

    public void setMemoryMiB(MemoryMiBRequest memoryMiB) {
        this.memoryMiB = memoryMiB;
    }

    public MemoryMiBRequest getMemoryMiB() {
        return this.memoryMiB;
    }

    public InstanceRequirements withMemoryMiB(MemoryMiBRequest memoryMiB) {
        this.setMemoryMiB(memoryMiB);
        return this;
    }

    public List<String> getCpuManufacturers() {
        if (this.cpuManufacturers == null) {
            this.cpuManufacturers = new SdkInternalList();
        }
        return this.cpuManufacturers;
    }

    public void setCpuManufacturers(Collection<String> cpuManufacturers) {
        if (cpuManufacturers == null) {
            this.cpuManufacturers = null;
            return;
        }
        this.cpuManufacturers = new SdkInternalList(cpuManufacturers);
    }

    public InstanceRequirements withCpuManufacturers(String ... cpuManufacturers) {
        if (this.cpuManufacturers == null) {
            this.setCpuManufacturers((Collection<String>)new SdkInternalList(cpuManufacturers.length));
        }
        for (String ele : cpuManufacturers) {
            this.cpuManufacturers.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withCpuManufacturers(Collection<String> cpuManufacturers) {
        this.setCpuManufacturers(cpuManufacturers);
        return this;
    }

    public InstanceRequirements withCpuManufacturers(CpuManufacturer ... cpuManufacturers) {
        SdkInternalList cpuManufacturersCopy = new SdkInternalList(cpuManufacturers.length);
        for (CpuManufacturer value : cpuManufacturers) {
            cpuManufacturersCopy.add((Object)value.toString());
        }
        if (this.getCpuManufacturers() == null) {
            this.setCpuManufacturers((Collection<String>)cpuManufacturersCopy);
        } else {
            this.getCpuManufacturers().addAll((Collection<String>)cpuManufacturersCopy);
        }
        return this;
    }

    public void setMemoryGiBPerVCpu(MemoryGiBPerVCpuRequest memoryGiBPerVCpu) {
        this.memoryGiBPerVCpu = memoryGiBPerVCpu;
    }

    public MemoryGiBPerVCpuRequest getMemoryGiBPerVCpu() {
        return this.memoryGiBPerVCpu;
    }

    public InstanceRequirements withMemoryGiBPerVCpu(MemoryGiBPerVCpuRequest memoryGiBPerVCpu) {
        this.setMemoryGiBPerVCpu(memoryGiBPerVCpu);
        return this;
    }

    public List<String> getExcludedInstanceTypes() {
        if (this.excludedInstanceTypes == null) {
            this.excludedInstanceTypes = new SdkInternalList();
        }
        return this.excludedInstanceTypes;
    }

    public void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
        if (excludedInstanceTypes == null) {
            this.excludedInstanceTypes = null;
            return;
        }
        this.excludedInstanceTypes = new SdkInternalList(excludedInstanceTypes);
    }

    public InstanceRequirements withExcludedInstanceTypes(String ... excludedInstanceTypes) {
        if (this.excludedInstanceTypes == null) {
            this.setExcludedInstanceTypes((Collection<String>)new SdkInternalList(excludedInstanceTypes.length));
        }
        for (String ele : excludedInstanceTypes) {
            this.excludedInstanceTypes.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
        this.setExcludedInstanceTypes(excludedInstanceTypes);
        return this;
    }

    public List<String> getInstanceGenerations() {
        if (this.instanceGenerations == null) {
            this.instanceGenerations = new SdkInternalList();
        }
        return this.instanceGenerations;
    }

    public void setInstanceGenerations(Collection<String> instanceGenerations) {
        if (instanceGenerations == null) {
            this.instanceGenerations = null;
            return;
        }
        this.instanceGenerations = new SdkInternalList(instanceGenerations);
    }

    public InstanceRequirements withInstanceGenerations(String ... instanceGenerations) {
        if (this.instanceGenerations == null) {
            this.setInstanceGenerations((Collection<String>)new SdkInternalList(instanceGenerations.length));
        }
        for (String ele : instanceGenerations) {
            this.instanceGenerations.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withInstanceGenerations(Collection<String> instanceGenerations) {
        this.setInstanceGenerations(instanceGenerations);
        return this;
    }

    public InstanceRequirements withInstanceGenerations(InstanceGeneration ... instanceGenerations) {
        SdkInternalList instanceGenerationsCopy = new SdkInternalList(instanceGenerations.length);
        for (InstanceGeneration value : instanceGenerations) {
            instanceGenerationsCopy.add((Object)value.toString());
        }
        if (this.getInstanceGenerations() == null) {
            this.setInstanceGenerations((Collection<String>)instanceGenerationsCopy);
        } else {
            this.getInstanceGenerations().addAll((Collection<String>)instanceGenerationsCopy);
        }
        return this;
    }

    public void setSpotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
        this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
    }

    public Integer getSpotMaxPricePercentageOverLowestPrice() {
        return this.spotMaxPricePercentageOverLowestPrice;
    }

    public InstanceRequirements withSpotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
        this.setSpotMaxPricePercentageOverLowestPrice(spotMaxPricePercentageOverLowestPrice);
        return this;
    }

    public void setMaxSpotPriceAsPercentageOfOptimalOnDemandPrice(Integer maxSpotPriceAsPercentageOfOptimalOnDemandPrice) {
        this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
    }

    public Integer getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() {
        return this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
    }

    public InstanceRequirements withMaxSpotPriceAsPercentageOfOptimalOnDemandPrice(Integer maxSpotPriceAsPercentageOfOptimalOnDemandPrice) {
        this.setMaxSpotPriceAsPercentageOfOptimalOnDemandPrice(maxSpotPriceAsPercentageOfOptimalOnDemandPrice);
        return this;
    }

    public void setOnDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
        this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
    }

    public Integer getOnDemandMaxPricePercentageOverLowestPrice() {
        return this.onDemandMaxPricePercentageOverLowestPrice;
    }

    public InstanceRequirements withOnDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
        this.setOnDemandMaxPricePercentageOverLowestPrice(onDemandMaxPricePercentageOverLowestPrice);
        return this;
    }

    public void setBareMetal(String bareMetal) {
        this.bareMetal = bareMetal;
    }

    public String getBareMetal() {
        return this.bareMetal;
    }

    public InstanceRequirements withBareMetal(String bareMetal) {
        this.setBareMetal(bareMetal);
        return this;
    }

    public InstanceRequirements withBareMetal(BareMetal bareMetal) {
        this.bareMetal = bareMetal.toString();
        return this;
    }

    public void setBurstablePerformance(String burstablePerformance) {
        this.burstablePerformance = burstablePerformance;
    }

    public String getBurstablePerformance() {
        return this.burstablePerformance;
    }

    public InstanceRequirements withBurstablePerformance(String burstablePerformance) {
        this.setBurstablePerformance(burstablePerformance);
        return this;
    }

    public InstanceRequirements withBurstablePerformance(BurstablePerformance burstablePerformance) {
        this.burstablePerformance = burstablePerformance.toString();
        return this;
    }

    public void setRequireHibernateSupport(Boolean requireHibernateSupport) {
        this.requireHibernateSupport = requireHibernateSupport;
    }

    public Boolean getRequireHibernateSupport() {
        return this.requireHibernateSupport;
    }

    public InstanceRequirements withRequireHibernateSupport(Boolean requireHibernateSupport) {
        this.setRequireHibernateSupport(requireHibernateSupport);
        return this;
    }

    public Boolean isRequireHibernateSupport() {
        return this.requireHibernateSupport;
    }

    public void setNetworkInterfaceCount(NetworkInterfaceCountRequest networkInterfaceCount) {
        this.networkInterfaceCount = networkInterfaceCount;
    }

    public NetworkInterfaceCountRequest getNetworkInterfaceCount() {
        return this.networkInterfaceCount;
    }

    public InstanceRequirements withNetworkInterfaceCount(NetworkInterfaceCountRequest networkInterfaceCount) {
        this.setNetworkInterfaceCount(networkInterfaceCount);
        return this;
    }

    public void setLocalStorage(String localStorage) {
        this.localStorage = localStorage;
    }

    public String getLocalStorage() {
        return this.localStorage;
    }

    public InstanceRequirements withLocalStorage(String localStorage) {
        this.setLocalStorage(localStorage);
        return this;
    }

    public InstanceRequirements withLocalStorage(LocalStorage localStorage) {
        this.localStorage = localStorage.toString();
        return this;
    }

    public List<String> getLocalStorageTypes() {
        if (this.localStorageTypes == null) {
            this.localStorageTypes = new SdkInternalList();
        }
        return this.localStorageTypes;
    }

    public void setLocalStorageTypes(Collection<String> localStorageTypes) {
        if (localStorageTypes == null) {
            this.localStorageTypes = null;
            return;
        }
        this.localStorageTypes = new SdkInternalList(localStorageTypes);
    }

    public InstanceRequirements withLocalStorageTypes(String ... localStorageTypes) {
        if (this.localStorageTypes == null) {
            this.setLocalStorageTypes((Collection<String>)new SdkInternalList(localStorageTypes.length));
        }
        for (String ele : localStorageTypes) {
            this.localStorageTypes.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withLocalStorageTypes(Collection<String> localStorageTypes) {
        this.setLocalStorageTypes(localStorageTypes);
        return this;
    }

    public InstanceRequirements withLocalStorageTypes(LocalStorageType ... localStorageTypes) {
        SdkInternalList localStorageTypesCopy = new SdkInternalList(localStorageTypes.length);
        for (LocalStorageType value : localStorageTypes) {
            localStorageTypesCopy.add((Object)value.toString());
        }
        if (this.getLocalStorageTypes() == null) {
            this.setLocalStorageTypes((Collection<String>)localStorageTypesCopy);
        } else {
            this.getLocalStorageTypes().addAll((Collection<String>)localStorageTypesCopy);
        }
        return this;
    }

    public void setTotalLocalStorageGB(TotalLocalStorageGBRequest totalLocalStorageGB) {
        this.totalLocalStorageGB = totalLocalStorageGB;
    }

    public TotalLocalStorageGBRequest getTotalLocalStorageGB() {
        return this.totalLocalStorageGB;
    }

    public InstanceRequirements withTotalLocalStorageGB(TotalLocalStorageGBRequest totalLocalStorageGB) {
        this.setTotalLocalStorageGB(totalLocalStorageGB);
        return this;
    }

    public void setBaselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps) {
        this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
    }

    public BaselineEbsBandwidthMbpsRequest getBaselineEbsBandwidthMbps() {
        return this.baselineEbsBandwidthMbps;
    }

    public InstanceRequirements withBaselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps) {
        this.setBaselineEbsBandwidthMbps(baselineEbsBandwidthMbps);
        return this;
    }

    public List<String> getAcceleratorTypes() {
        if (this.acceleratorTypes == null) {
            this.acceleratorTypes = new SdkInternalList();
        }
        return this.acceleratorTypes;
    }

    public void setAcceleratorTypes(Collection<String> acceleratorTypes) {
        if (acceleratorTypes == null) {
            this.acceleratorTypes = null;
            return;
        }
        this.acceleratorTypes = new SdkInternalList(acceleratorTypes);
    }

    public InstanceRequirements withAcceleratorTypes(String ... acceleratorTypes) {
        if (this.acceleratorTypes == null) {
            this.setAcceleratorTypes((Collection<String>)new SdkInternalList(acceleratorTypes.length));
        }
        for (String ele : acceleratorTypes) {
            this.acceleratorTypes.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withAcceleratorTypes(Collection<String> acceleratorTypes) {
        this.setAcceleratorTypes(acceleratorTypes);
        return this;
    }

    public InstanceRequirements withAcceleratorTypes(AcceleratorType ... acceleratorTypes) {
        SdkInternalList acceleratorTypesCopy = new SdkInternalList(acceleratorTypes.length);
        for (AcceleratorType value : acceleratorTypes) {
            acceleratorTypesCopy.add((Object)value.toString());
        }
        if (this.getAcceleratorTypes() == null) {
            this.setAcceleratorTypes((Collection<String>)acceleratorTypesCopy);
        } else {
            this.getAcceleratorTypes().addAll((Collection<String>)acceleratorTypesCopy);
        }
        return this;
    }

    public void setAcceleratorCount(AcceleratorCountRequest acceleratorCount) {
        this.acceleratorCount = acceleratorCount;
    }

    public AcceleratorCountRequest getAcceleratorCount() {
        return this.acceleratorCount;
    }

    public InstanceRequirements withAcceleratorCount(AcceleratorCountRequest acceleratorCount) {
        this.setAcceleratorCount(acceleratorCount);
        return this;
    }

    public List<String> getAcceleratorManufacturers() {
        if (this.acceleratorManufacturers == null) {
            this.acceleratorManufacturers = new SdkInternalList();
        }
        return this.acceleratorManufacturers;
    }

    public void setAcceleratorManufacturers(Collection<String> acceleratorManufacturers) {
        if (acceleratorManufacturers == null) {
            this.acceleratorManufacturers = null;
            return;
        }
        this.acceleratorManufacturers = new SdkInternalList(acceleratorManufacturers);
    }

    public InstanceRequirements withAcceleratorManufacturers(String ... acceleratorManufacturers) {
        if (this.acceleratorManufacturers == null) {
            this.setAcceleratorManufacturers((Collection<String>)new SdkInternalList(acceleratorManufacturers.length));
        }
        for (String ele : acceleratorManufacturers) {
            this.acceleratorManufacturers.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withAcceleratorManufacturers(Collection<String> acceleratorManufacturers) {
        this.setAcceleratorManufacturers(acceleratorManufacturers);
        return this;
    }

    public InstanceRequirements withAcceleratorManufacturers(AcceleratorManufacturer ... acceleratorManufacturers) {
        SdkInternalList acceleratorManufacturersCopy = new SdkInternalList(acceleratorManufacturers.length);
        for (AcceleratorManufacturer value : acceleratorManufacturers) {
            acceleratorManufacturersCopy.add((Object)value.toString());
        }
        if (this.getAcceleratorManufacturers() == null) {
            this.setAcceleratorManufacturers((Collection<String>)acceleratorManufacturersCopy);
        } else {
            this.getAcceleratorManufacturers().addAll((Collection<String>)acceleratorManufacturersCopy);
        }
        return this;
    }

    public List<String> getAcceleratorNames() {
        if (this.acceleratorNames == null) {
            this.acceleratorNames = new SdkInternalList();
        }
        return this.acceleratorNames;
    }

    public void setAcceleratorNames(Collection<String> acceleratorNames) {
        if (acceleratorNames == null) {
            this.acceleratorNames = null;
            return;
        }
        this.acceleratorNames = new SdkInternalList(acceleratorNames);
    }

    public InstanceRequirements withAcceleratorNames(String ... acceleratorNames) {
        if (this.acceleratorNames == null) {
            this.setAcceleratorNames((Collection<String>)new SdkInternalList(acceleratorNames.length));
        }
        for (String ele : acceleratorNames) {
            this.acceleratorNames.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withAcceleratorNames(Collection<String> acceleratorNames) {
        this.setAcceleratorNames(acceleratorNames);
        return this;
    }

    public InstanceRequirements withAcceleratorNames(AcceleratorName ... acceleratorNames) {
        SdkInternalList acceleratorNamesCopy = new SdkInternalList(acceleratorNames.length);
        for (AcceleratorName value : acceleratorNames) {
            acceleratorNamesCopy.add((Object)value.toString());
        }
        if (this.getAcceleratorNames() == null) {
            this.setAcceleratorNames((Collection<String>)acceleratorNamesCopy);
        } else {
            this.getAcceleratorNames().addAll((Collection<String>)acceleratorNamesCopy);
        }
        return this;
    }

    public void setAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB) {
        this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
    }

    public AcceleratorTotalMemoryMiBRequest getAcceleratorTotalMemoryMiB() {
        return this.acceleratorTotalMemoryMiB;
    }

    public InstanceRequirements withAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB) {
        this.setAcceleratorTotalMemoryMiB(acceleratorTotalMemoryMiB);
        return this;
    }

    public void setNetworkBandwidthGbps(NetworkBandwidthGbpsRequest networkBandwidthGbps) {
        this.networkBandwidthGbps = networkBandwidthGbps;
    }

    public NetworkBandwidthGbpsRequest getNetworkBandwidthGbps() {
        return this.networkBandwidthGbps;
    }

    public InstanceRequirements withNetworkBandwidthGbps(NetworkBandwidthGbpsRequest networkBandwidthGbps) {
        this.setNetworkBandwidthGbps(networkBandwidthGbps);
        return this;
    }

    public List<String> getAllowedInstanceTypes() {
        if (this.allowedInstanceTypes == null) {
            this.allowedInstanceTypes = new SdkInternalList();
        }
        return this.allowedInstanceTypes;
    }

    public void setAllowedInstanceTypes(Collection<String> allowedInstanceTypes) {
        if (allowedInstanceTypes == null) {
            this.allowedInstanceTypes = null;
            return;
        }
        this.allowedInstanceTypes = new SdkInternalList(allowedInstanceTypes);
    }

    public InstanceRequirements withAllowedInstanceTypes(String ... allowedInstanceTypes) {
        if (this.allowedInstanceTypes == null) {
            this.setAllowedInstanceTypes((Collection<String>)new SdkInternalList(allowedInstanceTypes.length));
        }
        for (String ele : allowedInstanceTypes) {
            this.allowedInstanceTypes.add((Object)ele);
        }
        return this;
    }

    public InstanceRequirements withAllowedInstanceTypes(Collection<String> allowedInstanceTypes) {
        this.setAllowedInstanceTypes(allowedInstanceTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVCpuCount() != null) {
            sb.append("VCpuCount: ").append(this.getVCpuCount()).append(",");
        }
        if (this.getMemoryMiB() != null) {
            sb.append("MemoryMiB: ").append(this.getMemoryMiB()).append(",");
        }
        if (this.getCpuManufacturers() != null) {
            sb.append("CpuManufacturers: ").append(this.getCpuManufacturers()).append(",");
        }
        if (this.getMemoryGiBPerVCpu() != null) {
            sb.append("MemoryGiBPerVCpu: ").append(this.getMemoryGiBPerVCpu()).append(",");
        }
        if (this.getExcludedInstanceTypes() != null) {
            sb.append("ExcludedInstanceTypes: ").append(this.getExcludedInstanceTypes()).append(",");
        }
        if (this.getInstanceGenerations() != null) {
            sb.append("InstanceGenerations: ").append(this.getInstanceGenerations()).append(",");
        }
        if (this.getSpotMaxPricePercentageOverLowestPrice() != null) {
            sb.append("SpotMaxPricePercentageOverLowestPrice: ").append(this.getSpotMaxPricePercentageOverLowestPrice()).append(",");
        }
        if (this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() != null) {
            sb.append("MaxSpotPriceAsPercentageOfOptimalOnDemandPrice: ").append(this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice()).append(",");
        }
        if (this.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
            sb.append("OnDemandMaxPricePercentageOverLowestPrice: ").append(this.getOnDemandMaxPricePercentageOverLowestPrice()).append(",");
        }
        if (this.getBareMetal() != null) {
            sb.append("BareMetal: ").append(this.getBareMetal()).append(",");
        }
        if (this.getBurstablePerformance() != null) {
            sb.append("BurstablePerformance: ").append(this.getBurstablePerformance()).append(",");
        }
        if (this.getRequireHibernateSupport() != null) {
            sb.append("RequireHibernateSupport: ").append(this.getRequireHibernateSupport()).append(",");
        }
        if (this.getNetworkInterfaceCount() != null) {
            sb.append("NetworkInterfaceCount: ").append(this.getNetworkInterfaceCount()).append(",");
        }
        if (this.getLocalStorage() != null) {
            sb.append("LocalStorage: ").append(this.getLocalStorage()).append(",");
        }
        if (this.getLocalStorageTypes() != null) {
            sb.append("LocalStorageTypes: ").append(this.getLocalStorageTypes()).append(",");
        }
        if (this.getTotalLocalStorageGB() != null) {
            sb.append("TotalLocalStorageGB: ").append(this.getTotalLocalStorageGB()).append(",");
        }
        if (this.getBaselineEbsBandwidthMbps() != null) {
            sb.append("BaselineEbsBandwidthMbps: ").append(this.getBaselineEbsBandwidthMbps()).append(",");
        }
        if (this.getAcceleratorTypes() != null) {
            sb.append("AcceleratorTypes: ").append(this.getAcceleratorTypes()).append(",");
        }
        if (this.getAcceleratorCount() != null) {
            sb.append("AcceleratorCount: ").append(this.getAcceleratorCount()).append(",");
        }
        if (this.getAcceleratorManufacturers() != null) {
            sb.append("AcceleratorManufacturers: ").append(this.getAcceleratorManufacturers()).append(",");
        }
        if (this.getAcceleratorNames() != null) {
            sb.append("AcceleratorNames: ").append(this.getAcceleratorNames()).append(",");
        }
        if (this.getAcceleratorTotalMemoryMiB() != null) {
            sb.append("AcceleratorTotalMemoryMiB: ").append(this.getAcceleratorTotalMemoryMiB()).append(",");
        }
        if (this.getNetworkBandwidthGbps() != null) {
            sb.append("NetworkBandwidthGbps: ").append(this.getNetworkBandwidthGbps()).append(",");
        }
        if (this.getAllowedInstanceTypes() != null) {
            sb.append("AllowedInstanceTypes: ").append(this.getAllowedInstanceTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRequirements)) {
            return false;
        }
        InstanceRequirements other = (InstanceRequirements)obj;
        if (other.getVCpuCount() == null ^ this.getVCpuCount() == null) {
            return false;
        }
        if (other.getVCpuCount() != null && !other.getVCpuCount().equals(this.getVCpuCount())) {
            return false;
        }
        if (other.getMemoryMiB() == null ^ this.getMemoryMiB() == null) {
            return false;
        }
        if (other.getMemoryMiB() != null && !other.getMemoryMiB().equals(this.getMemoryMiB())) {
            return false;
        }
        if (other.getCpuManufacturers() == null ^ this.getCpuManufacturers() == null) {
            return false;
        }
        if (other.getCpuManufacturers() != null && !other.getCpuManufacturers().equals(this.getCpuManufacturers())) {
            return false;
        }
        if (other.getMemoryGiBPerVCpu() == null ^ this.getMemoryGiBPerVCpu() == null) {
            return false;
        }
        if (other.getMemoryGiBPerVCpu() != null && !other.getMemoryGiBPerVCpu().equals(this.getMemoryGiBPerVCpu())) {
            return false;
        }
        if (other.getExcludedInstanceTypes() == null ^ this.getExcludedInstanceTypes() == null) {
            return false;
        }
        if (other.getExcludedInstanceTypes() != null && !other.getExcludedInstanceTypes().equals(this.getExcludedInstanceTypes())) {
            return false;
        }
        if (other.getInstanceGenerations() == null ^ this.getInstanceGenerations() == null) {
            return false;
        }
        if (other.getInstanceGenerations() != null && !other.getInstanceGenerations().equals(this.getInstanceGenerations())) {
            return false;
        }
        if (other.getSpotMaxPricePercentageOverLowestPrice() == null ^ this.getSpotMaxPricePercentageOverLowestPrice() == null) {
            return false;
        }
        if (other.getSpotMaxPricePercentageOverLowestPrice() != null && !other.getSpotMaxPricePercentageOverLowestPrice().equals(this.getSpotMaxPricePercentageOverLowestPrice())) {
            return false;
        }
        if (other.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() == null ^ this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() == null) {
            return false;
        }
        if (other.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() != null && !other.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice().equals(this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice())) {
            return false;
        }
        if (other.getOnDemandMaxPricePercentageOverLowestPrice() == null ^ this.getOnDemandMaxPricePercentageOverLowestPrice() == null) {
            return false;
        }
        if (other.getOnDemandMaxPricePercentageOverLowestPrice() != null && !other.getOnDemandMaxPricePercentageOverLowestPrice().equals(this.getOnDemandMaxPricePercentageOverLowestPrice())) {
            return false;
        }
        if (other.getBareMetal() == null ^ this.getBareMetal() == null) {
            return false;
        }
        if (other.getBareMetal() != null && !other.getBareMetal().equals(this.getBareMetal())) {
            return false;
        }
        if (other.getBurstablePerformance() == null ^ this.getBurstablePerformance() == null) {
            return false;
        }
        if (other.getBurstablePerformance() != null && !other.getBurstablePerformance().equals(this.getBurstablePerformance())) {
            return false;
        }
        if (other.getRequireHibernateSupport() == null ^ this.getRequireHibernateSupport() == null) {
            return false;
        }
        if (other.getRequireHibernateSupport() != null && !other.getRequireHibernateSupport().equals(this.getRequireHibernateSupport())) {
            return false;
        }
        if (other.getNetworkInterfaceCount() == null ^ this.getNetworkInterfaceCount() == null) {
            return false;
        }
        if (other.getNetworkInterfaceCount() != null && !other.getNetworkInterfaceCount().equals(this.getNetworkInterfaceCount())) {
            return false;
        }
        if (other.getLocalStorage() == null ^ this.getLocalStorage() == null) {
            return false;
        }
        if (other.getLocalStorage() != null && !other.getLocalStorage().equals(this.getLocalStorage())) {
            return false;
        }
        if (other.getLocalStorageTypes() == null ^ this.getLocalStorageTypes() == null) {
            return false;
        }
        if (other.getLocalStorageTypes() != null && !other.getLocalStorageTypes().equals(this.getLocalStorageTypes())) {
            return false;
        }
        if (other.getTotalLocalStorageGB() == null ^ this.getTotalLocalStorageGB() == null) {
            return false;
        }
        if (other.getTotalLocalStorageGB() != null && !other.getTotalLocalStorageGB().equals(this.getTotalLocalStorageGB())) {
            return false;
        }
        if (other.getBaselineEbsBandwidthMbps() == null ^ this.getBaselineEbsBandwidthMbps() == null) {
            return false;
        }
        if (other.getBaselineEbsBandwidthMbps() != null && !other.getBaselineEbsBandwidthMbps().equals(this.getBaselineEbsBandwidthMbps())) {
            return false;
        }
        if (other.getAcceleratorTypes() == null ^ this.getAcceleratorTypes() == null) {
            return false;
        }
        if (other.getAcceleratorTypes() != null && !other.getAcceleratorTypes().equals(this.getAcceleratorTypes())) {
            return false;
        }
        if (other.getAcceleratorCount() == null ^ this.getAcceleratorCount() == null) {
            return false;
        }
        if (other.getAcceleratorCount() != null && !other.getAcceleratorCount().equals(this.getAcceleratorCount())) {
            return false;
        }
        if (other.getAcceleratorManufacturers() == null ^ this.getAcceleratorManufacturers() == null) {
            return false;
        }
        if (other.getAcceleratorManufacturers() != null && !other.getAcceleratorManufacturers().equals(this.getAcceleratorManufacturers())) {
            return false;
        }
        if (other.getAcceleratorNames() == null ^ this.getAcceleratorNames() == null) {
            return false;
        }
        if (other.getAcceleratorNames() != null && !other.getAcceleratorNames().equals(this.getAcceleratorNames())) {
            return false;
        }
        if (other.getAcceleratorTotalMemoryMiB() == null ^ this.getAcceleratorTotalMemoryMiB() == null) {
            return false;
        }
        if (other.getAcceleratorTotalMemoryMiB() != null && !other.getAcceleratorTotalMemoryMiB().equals(this.getAcceleratorTotalMemoryMiB())) {
            return false;
        }
        if (other.getNetworkBandwidthGbps() == null ^ this.getNetworkBandwidthGbps() == null) {
            return false;
        }
        if (other.getNetworkBandwidthGbps() != null && !other.getNetworkBandwidthGbps().equals(this.getNetworkBandwidthGbps())) {
            return false;
        }
        if (other.getAllowedInstanceTypes() == null ^ this.getAllowedInstanceTypes() == null) {
            return false;
        }
        return other.getAllowedInstanceTypes() == null || other.getAllowedInstanceTypes().equals(this.getAllowedInstanceTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVCpuCount() == null ? 0 : this.getVCpuCount().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryMiB() == null ? 0 : this.getMemoryMiB().hashCode());
        hashCode = 31 * hashCode + (this.getCpuManufacturers() == null ? 0 : this.getCpuManufacturers().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryGiBPerVCpu() == null ? 0 : this.getMemoryGiBPerVCpu().hashCode());
        hashCode = 31 * hashCode + (this.getExcludedInstanceTypes() == null ? 0 : this.getExcludedInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGenerations() == null ? 0 : this.getInstanceGenerations().hashCode());
        hashCode = 31 * hashCode + (this.getSpotMaxPricePercentageOverLowestPrice() == null ? 0 : this.getSpotMaxPricePercentageOverLowestPrice().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() == null ? 0 : this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandMaxPricePercentageOverLowestPrice() == null ? 0 : this.getOnDemandMaxPricePercentageOverLowestPrice().hashCode());
        hashCode = 31 * hashCode + (this.getBareMetal() == null ? 0 : this.getBareMetal().hashCode());
        hashCode = 31 * hashCode + (this.getBurstablePerformance() == null ? 0 : this.getBurstablePerformance().hashCode());
        hashCode = 31 * hashCode + (this.getRequireHibernateSupport() == null ? 0 : this.getRequireHibernateSupport().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaceCount() == null ? 0 : this.getNetworkInterfaceCount().hashCode());
        hashCode = 31 * hashCode + (this.getLocalStorage() == null ? 0 : this.getLocalStorage().hashCode());
        hashCode = 31 * hashCode + (this.getLocalStorageTypes() == null ? 0 : this.getLocalStorageTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTotalLocalStorageGB() == null ? 0 : this.getTotalLocalStorageGB().hashCode());
        hashCode = 31 * hashCode + (this.getBaselineEbsBandwidthMbps() == null ? 0 : this.getBaselineEbsBandwidthMbps().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorTypes() == null ? 0 : this.getAcceleratorTypes().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorCount() == null ? 0 : this.getAcceleratorCount().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorManufacturers() == null ? 0 : this.getAcceleratorManufacturers().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorNames() == null ? 0 : this.getAcceleratorNames().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorTotalMemoryMiB() == null ? 0 : this.getAcceleratorTotalMemoryMiB().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkBandwidthGbps() == null ? 0 : this.getNetworkBandwidthGbps().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedInstanceTypes() == null ? 0 : this.getAllowedInstanceTypes().hashCode());
        return hashCode;
    }

    public InstanceRequirements clone() {
        try {
            return (InstanceRequirements)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

