/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeScheduledActionsRequestMarshaller
implements Marshaller<Request<DescribeScheduledActionsRequest>, DescribeScheduledActionsRequest> {
    public Request<DescribeScheduledActionsRequest> marshall(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        if (describeScheduledActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledActionsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeScheduledActions");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeScheduledActionsRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describeScheduledActionsRequest.getAutoScalingGroupName()));
        }
        if (!describeScheduledActionsRequest.getScheduledActionNames().isEmpty() || !((SdkInternalList)describeScheduledActionsRequest.getScheduledActionNames()).isAutoConstruct()) {
            SdkInternalList scheduledActionNamesList = (SdkInternalList)describeScheduledActionsRequest.getScheduledActionNames();
            int scheduledActionNamesListIndex = 1;
            for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                if (scheduledActionNamesListValue != null) {
                    request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex, StringUtils.fromString((String)scheduledActionNamesListValue));
                }
                ++scheduledActionNamesListIndex;
            }
        }
        if (describeScheduledActionsRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeScheduledActionsRequest.getStartTime()));
        }
        if (describeScheduledActionsRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeScheduledActionsRequest.getEndTime()));
        }
        if (describeScheduledActionsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScheduledActionsRequest.getNextToken()));
        }
        if (describeScheduledActionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeScheduledActionsRequest.getMaxRecords()));
        }
        return request;
    }
}

