/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.Control;
import com.amazonaws.services.auditmanager.model.transform.ControlSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ControlSet
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private List<Control> controls;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ControlSet withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ControlSet withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public void setControls(Collection<Control> controls) {
        if (controls == null) {
            this.controls = null;
            return;
        }
        this.controls = new ArrayList<Control>(controls);
    }

    public ControlSet withControls(Control ... controls) {
        if (this.controls == null) {
            this.setControls(new ArrayList<Control>(controls.length));
        }
        for (Control ele : controls) {
            this.controls.add(ele);
        }
        return this;
    }

    public ControlSet withControls(Collection<Control> controls) {
        this.setControls(controls);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getControls() != null) {
            sb.append("Controls: ").append(this.getControls());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlSet)) {
            return false;
        }
        ControlSet other = (ControlSet)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getControls() == null ^ this.getControls() == null) {
            return false;
        }
        return other.getControls() == null || other.getControls().equals(this.getControls());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getControls() == null ? 0 : this.getControls().hashCode());
        return hashCode;
    }

    public ControlSet clone() {
        try {
            return (ControlSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ControlSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

