/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.auditmanager.model.AssessmentReportsDestination;
import com.amazonaws.services.auditmanager.model.Role;
import com.amazonaws.services.auditmanager.model.Scope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAssessmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private AssessmentReportsDestination assessmentReportsDestination;
    private Scope scope;
    private List<Role> roles;
    private String frameworkId;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateAssessmentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateAssessmentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setAssessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination) {
        this.assessmentReportsDestination = assessmentReportsDestination;
    }

    public AssessmentReportsDestination getAssessmentReportsDestination() {
        return this.assessmentReportsDestination;
    }

    public CreateAssessmentRequest withAssessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination) {
        this.setAssessmentReportsDestination(assessmentReportsDestination);
        return this;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public CreateAssessmentRequest withScope(Scope scope) {
        this.setScope(scope);
        return this;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
            return;
        }
        this.roles = new ArrayList<Role>(roles);
    }

    public CreateAssessmentRequest withRoles(Role ... roles) {
        if (this.roles == null) {
            this.setRoles(new ArrayList<Role>(roles.length));
        }
        for (Role ele : roles) {
            this.roles.add(ele);
        }
        return this;
    }

    public CreateAssessmentRequest withRoles(Collection<Role> roles) {
        this.setRoles(roles);
        return this;
    }

    public void setFrameworkId(String frameworkId) {
        this.frameworkId = frameworkId;
    }

    public String getFrameworkId() {
        return this.frameworkId;
    }

    public CreateAssessmentRequest withFrameworkId(String frameworkId) {
        this.setFrameworkId(frameworkId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAssessmentRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAssessmentRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAssessmentRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAssessmentReportsDestination() != null) {
            sb.append("AssessmentReportsDestination: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRoles() != null) {
            sb.append("Roles: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFrameworkId() != null) {
            sb.append("FrameworkId: ").append(this.getFrameworkId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentRequest)) {
            return false;
        }
        CreateAssessmentRequest other = (CreateAssessmentRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getAssessmentReportsDestination() == null ^ this.getAssessmentReportsDestination() == null) {
            return false;
        }
        if (other.getAssessmentReportsDestination() != null && !other.getAssessmentReportsDestination().equals(this.getAssessmentReportsDestination())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        if (other.getRoles() != null && !other.getRoles().equals(this.getRoles())) {
            return false;
        }
        if (other.getFrameworkId() == null ^ this.getFrameworkId() == null) {
            return false;
        }
        if (other.getFrameworkId() != null && !other.getFrameworkId().equals(this.getFrameworkId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAssessmentReportsDestination() == null ? 0 : this.getAssessmentReportsDestination().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : this.getRoles().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkId() == null ? 0 : this.getFrameworkId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAssessmentRequest clone() {
        return (CreateAssessmentRequest)super.clone();
    }
}

