/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model.transform;

import com.amazonaws.services.auditmanager.model.Assessment;
import com.amazonaws.services.auditmanager.model.transform.AWSAccountJsonUnmarshaller;
import com.amazonaws.services.auditmanager.model.transform.AssessmentFrameworkJsonUnmarshaller;
import com.amazonaws.services.auditmanager.model.transform.AssessmentMetadataJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class AssessmentJsonUnmarshaller
implements Unmarshaller<Assessment, JsonUnmarshallerContext> {
    private static AssessmentJsonUnmarshaller instance;

    public Assessment unmarshall(JsonUnmarshallerContext context) throws Exception {
        Assessment assessment = new Assessment();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    assessment.setArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsAccount", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    assessment.setAwsAccount(AWSAccountJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("metadata", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    assessment.setMetadata(AssessmentMetadataJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("framework", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    assessment.setFramework(AssessmentFrameworkJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    assessment.setTags(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return assessment;
    }

    public static AssessmentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentJsonUnmarshaller();
        }
        return instance;
    }
}

