/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.auditmanager.model.Evidence;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class EvidenceMarshaller {
    private static final MarshallingInfo<String> DATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSource").build();
    private static final MarshallingInfo<String> EVIDENCEAWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("evidenceAwsAccountId").build();
    private static final MarshallingInfo<Date> TIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("time").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> EVENTSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventSource").build();
    private static final MarshallingInfo<String> EVENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventName").build();
    private static final MarshallingInfo<String> EVIDENCEBYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("evidenceByType").build();
    private static final MarshallingInfo<List> RESOURCESINCLUDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesIncluded").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<String> IAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamId").build();
    private static final MarshallingInfo<String> COMPLIANCECHECK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("complianceCheck").build();
    private static final MarshallingInfo<String> AWSORGANIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsOrganization").build();
    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsAccountId").build();
    private static final MarshallingInfo<String> EVIDENCEFOLDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("evidenceFolderId").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> ASSESSMENTREPORTSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assessmentReportSelection").build();
    private static final EvidenceMarshaller instance = new EvidenceMarshaller();

    public static EvidenceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Evidence evidence, ProtocolMarshaller protocolMarshaller) {
        if (evidence == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)evidence.getDataSource(), DATASOURCE_BINDING);
            protocolMarshaller.marshall((Object)evidence.getEvidenceAwsAccountId(), EVIDENCEAWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)evidence.getTime(), TIME_BINDING);
            protocolMarshaller.marshall((Object)evidence.getEventSource(), EVENTSOURCE_BINDING);
            protocolMarshaller.marshall((Object)evidence.getEventName(), EVENTNAME_BINDING);
            protocolMarshaller.marshall((Object)evidence.getEvidenceByType(), EVIDENCEBYTYPE_BINDING);
            protocolMarshaller.marshall(evidence.getResourcesIncluded(), RESOURCESINCLUDED_BINDING);
            protocolMarshaller.marshall(evidence.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)evidence.getIamId(), IAMID_BINDING);
            protocolMarshaller.marshall((Object)evidence.getComplianceCheck(), COMPLIANCECHECK_BINDING);
            protocolMarshaller.marshall((Object)evidence.getAwsOrganization(), AWSORGANIZATION_BINDING);
            protocolMarshaller.marshall((Object)evidence.getAwsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)evidence.getEvidenceFolderId(), EVIDENCEFOLDERID_BINDING);
            protocolMarshaller.marshall((Object)evidence.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)evidence.getAssessmentReportSelection(), ASSESSMENTREPORTSELECTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

