/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.arczonalshift;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.arczonalshift.AWSARCZonalShiftAsync;
import com.amazonaws.services.arczonalshift.AWSARCZonalShiftAsyncClientBuilder;
import com.amazonaws.services.arczonalshift.AWSARCZonalShiftClient;
import com.amazonaws.services.arczonalshift.model.CancelZonalShiftRequest;
import com.amazonaws.services.arczonalshift.model.CancelZonalShiftResult;
import com.amazonaws.services.arczonalshift.model.GetManagedResourceRequest;
import com.amazonaws.services.arczonalshift.model.GetManagedResourceResult;
import com.amazonaws.services.arczonalshift.model.ListManagedResourcesRequest;
import com.amazonaws.services.arczonalshift.model.ListManagedResourcesResult;
import com.amazonaws.services.arczonalshift.model.ListZonalShiftsRequest;
import com.amazonaws.services.arczonalshift.model.ListZonalShiftsResult;
import com.amazonaws.services.arczonalshift.model.StartZonalShiftRequest;
import com.amazonaws.services.arczonalshift.model.StartZonalShiftResult;
import com.amazonaws.services.arczonalshift.model.UpdateZonalShiftRequest;
import com.amazonaws.services.arczonalshift.model.UpdateZonalShiftResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSARCZonalShiftAsyncClient
extends AWSARCZonalShiftClient
implements AWSARCZonalShiftAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSARCZonalShiftAsyncClientBuilder asyncBuilder() {
        return AWSARCZonalShiftAsyncClientBuilder.standard();
    }

    AWSARCZonalShiftAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSARCZonalShiftAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelZonalShiftResult> cancelZonalShiftAsync(CancelZonalShiftRequest request) {
        return this.cancelZonalShiftAsync(request, null);
    }

    @Override
    public Future<CancelZonalShiftResult> cancelZonalShiftAsync(CancelZonalShiftRequest request, final AsyncHandler<CancelZonalShiftRequest, CancelZonalShiftResult> asyncHandler) {
        final CancelZonalShiftRequest finalRequest = (CancelZonalShiftRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelZonalShiftResult>(){

            @Override
            public CancelZonalShiftResult call() throws Exception {
                CancelZonalShiftResult result = null;
                try {
                    result = AWSARCZonalShiftAsyncClient.this.executeCancelZonalShift(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetManagedResourceResult> getManagedResourceAsync(GetManagedResourceRequest request) {
        return this.getManagedResourceAsync(request, null);
    }

    @Override
    public Future<GetManagedResourceResult> getManagedResourceAsync(GetManagedResourceRequest request, final AsyncHandler<GetManagedResourceRequest, GetManagedResourceResult> asyncHandler) {
        final GetManagedResourceRequest finalRequest = (GetManagedResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetManagedResourceResult>(){

            @Override
            public GetManagedResourceResult call() throws Exception {
                GetManagedResourceResult result = null;
                try {
                    result = AWSARCZonalShiftAsyncClient.this.executeGetManagedResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListManagedResourcesResult> listManagedResourcesAsync(ListManagedResourcesRequest request) {
        return this.listManagedResourcesAsync(request, null);
    }

    @Override
    public Future<ListManagedResourcesResult> listManagedResourcesAsync(ListManagedResourcesRequest request, final AsyncHandler<ListManagedResourcesRequest, ListManagedResourcesResult> asyncHandler) {
        final ListManagedResourcesRequest finalRequest = (ListManagedResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListManagedResourcesResult>(){

            @Override
            public ListManagedResourcesResult call() throws Exception {
                ListManagedResourcesResult result = null;
                try {
                    result = AWSARCZonalShiftAsyncClient.this.executeListManagedResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListZonalShiftsResult> listZonalShiftsAsync(ListZonalShiftsRequest request) {
        return this.listZonalShiftsAsync(request, null);
    }

    @Override
    public Future<ListZonalShiftsResult> listZonalShiftsAsync(ListZonalShiftsRequest request, final AsyncHandler<ListZonalShiftsRequest, ListZonalShiftsResult> asyncHandler) {
        final ListZonalShiftsRequest finalRequest = (ListZonalShiftsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListZonalShiftsResult>(){

            @Override
            public ListZonalShiftsResult call() throws Exception {
                ListZonalShiftsResult result = null;
                try {
                    result = AWSARCZonalShiftAsyncClient.this.executeListZonalShifts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartZonalShiftResult> startZonalShiftAsync(StartZonalShiftRequest request) {
        return this.startZonalShiftAsync(request, null);
    }

    @Override
    public Future<StartZonalShiftResult> startZonalShiftAsync(StartZonalShiftRequest request, final AsyncHandler<StartZonalShiftRequest, StartZonalShiftResult> asyncHandler) {
        final StartZonalShiftRequest finalRequest = (StartZonalShiftRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartZonalShiftResult>(){

            @Override
            public StartZonalShiftResult call() throws Exception {
                StartZonalShiftResult result = null;
                try {
                    result = AWSARCZonalShiftAsyncClient.this.executeStartZonalShift(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateZonalShiftResult> updateZonalShiftAsync(UpdateZonalShiftRequest request) {
        return this.updateZonalShiftAsync(request, null);
    }

    @Override
    public Future<UpdateZonalShiftResult> updateZonalShiftAsync(UpdateZonalShiftRequest request, final AsyncHandler<UpdateZonalShiftRequest, UpdateZonalShiftResult> asyncHandler) {
        final UpdateZonalShiftRequest finalRequest = (UpdateZonalShiftRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateZonalShiftResult>(){

            @Override
            public UpdateZonalShiftResult call() throws Exception {
                UpdateZonalShiftResult result = null;
                try {
                    result = AWSARCZonalShiftAsyncClient.this.executeUpdateZonalShift(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

