/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateMergedGraphqlApi"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DisassociateMergedGraphqlApiRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     */
    private String sourceApiIdentifier;
    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     */
    private String associationId;

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     * 
     * @param sourceApiIdentifier
     *        The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
     *        APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
     *        APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source
     *        API.
     */

    public void setSourceApiIdentifier(String sourceApiIdentifier) {
        this.sourceApiIdentifier = sourceApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     * 
     * @return The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
     *         APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
     *         APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source
     *         API.
     */

    public String getSourceApiIdentifier() {
        return this.sourceApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     * 
     * @param sourceApiIdentifier
     *        The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
     *        APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
     *        APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source
     *        API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DisassociateMergedGraphqlApiRequest withSourceApiIdentifier(String sourceApiIdentifier) {
        setSourceApiIdentifier(sourceApiIdentifier);
        return this;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @param associationId
     *        The ID generated by the AppSync service for the source API association.
     */

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @return The ID generated by the AppSync service for the source API association.
     */

    public String getAssociationId() {
        return this.associationId;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @param associationId
     *        The ID generated by the AppSync service for the source API association.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DisassociateMergedGraphqlApiRequest withAssociationId(String associationId) {
        setAssociationId(associationId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSourceApiIdentifier() != null)
            sb.append("SourceApiIdentifier: ").append(getSourceApiIdentifier()).append(",");
        if (getAssociationId() != null)
            sb.append("AssociationId: ").append(getAssociationId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DisassociateMergedGraphqlApiRequest == false)
            return false;
        DisassociateMergedGraphqlApiRequest other = (DisassociateMergedGraphqlApiRequest) obj;
        if (other.getSourceApiIdentifier() == null ^ this.getSourceApiIdentifier() == null)
            return false;
        if (other.getSourceApiIdentifier() != null && other.getSourceApiIdentifier().equals(this.getSourceApiIdentifier()) == false)
            return false;
        if (other.getAssociationId() == null ^ this.getAssociationId() == null)
            return false;
        if (other.getAssociationId() != null && other.getAssociationId().equals(this.getAssociationId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSourceApiIdentifier() == null) ? 0 : getSourceApiIdentifier().hashCode());
        hashCode = prime * hashCode + ((getAssociationId() == null) ? 0 : getAssociationId().hashCode());
        return hashCode;
    }

    @Override
    public DisassociateMergedGraphqlApiRequest clone() {
        return (DisassociateMergedGraphqlApiRequest) super.clone();
    }

}
