/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync;

import javax.annotation.Generated;

import com.amazonaws.services.appsync.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAppSync}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppSync implements AWSAppSync {

    protected AbstractAWSAppSync() {
    }

    @Override
    public AssociateApiResult associateApi(AssociateApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateMergedGraphqlApiResult associateMergedGraphqlApi(AssociateMergedGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateSourceGraphqlApiResult associateSourceGraphqlApi(AssociateSourceGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApiCacheResult createApiCache(CreateApiCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApiKeyResult createApiKey(CreateApiKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSourceResult createDataSource(CreateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainNameResult createDomainName(CreateDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFunctionResult createFunction(CreateFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGraphqlApiResult createGraphqlApi(CreateGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResolverResult createResolver(CreateResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTypeResult createType(CreateTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApiCacheResult deleteApiCache(DeleteApiCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApiKeyResult deleteApiKey(DeleteApiKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainNameResult deleteDomainName(DeleteDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFunctionResult deleteFunction(DeleteFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGraphqlApiResult deleteGraphqlApi(DeleteGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResolverResult deleteResolver(DeleteResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTypeResult deleteType(DeleteTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateApiResult disassociateApi(DisassociateApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMergedGraphqlApiResult disassociateMergedGraphqlApi(DisassociateMergedGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateSourceGraphqlApiResult disassociateSourceGraphqlApi(DisassociateSourceGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EvaluateCodeResult evaluateCode(EvaluateCodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EvaluateMappingTemplateResult evaluateMappingTemplate(EvaluateMappingTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public FlushApiCacheResult flushApiCache(FlushApiCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApiAssociationResult getApiAssociation(GetApiAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApiCacheResult getApiCache(GetApiCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataSourceResult getDataSource(GetDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainNameResult getDomainName(GetDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFunctionResult getFunction(GetFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGraphqlApiResult getGraphqlApi(GetGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntrospectionSchemaResult getIntrospectionSchema(GetIntrospectionSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverResult getResolver(GetResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaCreationStatusResult getSchemaCreationStatus(GetSchemaCreationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSourceApiAssociationResult getSourceApiAssociation(GetSourceApiAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTypeResult getType(GetTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApiKeysResult listApiKeys(ListApiKeysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainNamesResult listDomainNames(ListDomainNamesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFunctionsResult listFunctions(ListFunctionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGraphqlApisResult listGraphqlApis(ListGraphqlApisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolversResult listResolvers(ListResolversRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolversByFunctionResult listResolversByFunction(ListResolversByFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSourceApiAssociationsResult listSourceApiAssociations(ListSourceApiAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTypesResult listTypes(ListTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTypesByAssociationResult listTypesByAssociation(ListTypesByAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSchemaCreationResult startSchemaCreation(StartSchemaCreationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSchemaMergeResult startSchemaMerge(StartSchemaMergeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApiCacheResult updateApiCache(UpdateApiCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApiKeyResult updateApiKey(UpdateApiKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDomainNameResult updateDomainName(UpdateDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFunctionResult updateFunction(UpdateFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGraphqlApiResult updateGraphqlApi(UpdateGraphqlApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResolverResult updateResolver(UpdateResolverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSourceApiAssociationResult updateSourceApiAssociation(UpdateSourceApiAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTypeResult updateType(UpdateTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
