/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appsync.model.AdditionalAuthenticationProvider;
import com.amazonaws.services.appsync.model.AuthenticationType;
import com.amazonaws.services.appsync.model.GraphQLApiVisibility;
import com.amazonaws.services.appsync.model.LambdaAuthorizerConfig;
import com.amazonaws.services.appsync.model.LogConfig;
import com.amazonaws.services.appsync.model.OpenIDConnectConfig;
import com.amazonaws.services.appsync.model.UserPoolConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateGraphqlApiRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private LogConfig logConfig;
    private String authenticationType;
    private UserPoolConfig userPoolConfig;
    private OpenIDConnectConfig openIDConnectConfig;
    private Map<String, String> tags;
    private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;
    private Boolean xrayEnabled;
    private LambdaAuthorizerConfig lambdaAuthorizerConfig;
    private String visibility;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateGraphqlApiRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public CreateGraphqlApiRequest withLogConfig(LogConfig logConfig) {
        this.setLogConfig(logConfig);
        return this;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public CreateGraphqlApiRequest withAuthenticationType(String authenticationType) {
        this.setAuthenticationType(authenticationType);
        return this;
    }

    public CreateGraphqlApiRequest withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    public void setUserPoolConfig(UserPoolConfig userPoolConfig) {
        this.userPoolConfig = userPoolConfig;
    }

    public UserPoolConfig getUserPoolConfig() {
        return this.userPoolConfig;
    }

    public CreateGraphqlApiRequest withUserPoolConfig(UserPoolConfig userPoolConfig) {
        this.setUserPoolConfig(userPoolConfig);
        return this;
    }

    public void setOpenIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
        this.openIDConnectConfig = openIDConnectConfig;
    }

    public OpenIDConnectConfig getOpenIDConnectConfig() {
        return this.openIDConnectConfig;
    }

    public CreateGraphqlApiRequest withOpenIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
        this.setOpenIDConnectConfig(openIDConnectConfig);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateGraphqlApiRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateGraphqlApiRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateGraphqlApiRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<AdditionalAuthenticationProvider> getAdditionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders;
    }

    public void setAdditionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
        if (additionalAuthenticationProviders == null) {
            this.additionalAuthenticationProviders = null;
            return;
        }
        this.additionalAuthenticationProviders = new ArrayList<AdditionalAuthenticationProvider>(additionalAuthenticationProviders);
    }

    public CreateGraphqlApiRequest withAdditionalAuthenticationProviders(AdditionalAuthenticationProvider ... additionalAuthenticationProviders) {
        if (this.additionalAuthenticationProviders == null) {
            this.setAdditionalAuthenticationProviders(new ArrayList<AdditionalAuthenticationProvider>(additionalAuthenticationProviders.length));
        }
        for (AdditionalAuthenticationProvider ele : additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders.add(ele);
        }
        return this;
    }

    public CreateGraphqlApiRequest withAdditionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
        this.setAdditionalAuthenticationProviders(additionalAuthenticationProviders);
        return this;
    }

    public void setXrayEnabled(Boolean xrayEnabled) {
        this.xrayEnabled = xrayEnabled;
    }

    public Boolean getXrayEnabled() {
        return this.xrayEnabled;
    }

    public CreateGraphqlApiRequest withXrayEnabled(Boolean xrayEnabled) {
        this.setXrayEnabled(xrayEnabled);
        return this;
    }

    public Boolean isXrayEnabled() {
        return this.xrayEnabled;
    }

    public void setLambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
        this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
    }

    public LambdaAuthorizerConfig getLambdaAuthorizerConfig() {
        return this.lambdaAuthorizerConfig;
    }

    public CreateGraphqlApiRequest withLambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
        this.setLambdaAuthorizerConfig(lambdaAuthorizerConfig);
        return this;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public CreateGraphqlApiRequest withVisibility(String visibility) {
        this.setVisibility(visibility);
        return this;
    }

    public CreateGraphqlApiRequest withVisibility(GraphQLApiVisibility visibility) {
        this.visibility = visibility.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getLogConfig() != null) {
            sb.append("LogConfig: ").append(this.getLogConfig()).append(",");
        }
        if (this.getAuthenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.getAuthenticationType()).append(",");
        }
        if (this.getUserPoolConfig() != null) {
            sb.append("UserPoolConfig: ").append(this.getUserPoolConfig()).append(",");
        }
        if (this.getOpenIDConnectConfig() != null) {
            sb.append("OpenIDConnectConfig: ").append(this.getOpenIDConnectConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAdditionalAuthenticationProviders() != null) {
            sb.append("AdditionalAuthenticationProviders: ").append(this.getAdditionalAuthenticationProviders()).append(",");
        }
        if (this.getXrayEnabled() != null) {
            sb.append("XrayEnabled: ").append(this.getXrayEnabled()).append(",");
        }
        if (this.getLambdaAuthorizerConfig() != null) {
            sb.append("LambdaAuthorizerConfig: ").append(this.getLambdaAuthorizerConfig()).append(",");
        }
        if (this.getVisibility() != null) {
            sb.append("Visibility: ").append(this.getVisibility());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphqlApiRequest)) {
            return false;
        }
        CreateGraphqlApiRequest other = (CreateGraphqlApiRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getLogConfig() == null ^ this.getLogConfig() == null) {
            return false;
        }
        if (other.getLogConfig() != null && !other.getLogConfig().equals(this.getLogConfig())) {
            return false;
        }
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null) {
            return false;
        }
        if (other.getAuthenticationType() != null && !other.getAuthenticationType().equals(this.getAuthenticationType())) {
            return false;
        }
        if (other.getUserPoolConfig() == null ^ this.getUserPoolConfig() == null) {
            return false;
        }
        if (other.getUserPoolConfig() != null && !other.getUserPoolConfig().equals(this.getUserPoolConfig())) {
            return false;
        }
        if (other.getOpenIDConnectConfig() == null ^ this.getOpenIDConnectConfig() == null) {
            return false;
        }
        if (other.getOpenIDConnectConfig() != null && !other.getOpenIDConnectConfig().equals(this.getOpenIDConnectConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAdditionalAuthenticationProviders() == null ^ this.getAdditionalAuthenticationProviders() == null) {
            return false;
        }
        if (other.getAdditionalAuthenticationProviders() != null && !other.getAdditionalAuthenticationProviders().equals(this.getAdditionalAuthenticationProviders())) {
            return false;
        }
        if (other.getXrayEnabled() == null ^ this.getXrayEnabled() == null) {
            return false;
        }
        if (other.getXrayEnabled() != null && !other.getXrayEnabled().equals(this.getXrayEnabled())) {
            return false;
        }
        if (other.getLambdaAuthorizerConfig() == null ^ this.getLambdaAuthorizerConfig() == null) {
            return false;
        }
        if (other.getLambdaAuthorizerConfig() != null && !other.getLambdaAuthorizerConfig().equals(this.getLambdaAuthorizerConfig())) {
            return false;
        }
        if (other.getVisibility() == null ^ this.getVisibility() == null) {
            return false;
        }
        return other.getVisibility() == null || other.getVisibility().equals(this.getVisibility());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfig() == null ? 0 : this.getLogConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationType() == null ? 0 : this.getAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getUserPoolConfig() == null ? 0 : this.getUserPoolConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOpenIDConnectConfig() == null ? 0 : this.getOpenIDConnectConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalAuthenticationProviders() == null ? 0 : this.getAdditionalAuthenticationProviders().hashCode());
        hashCode = 31 * hashCode + (this.getXrayEnabled() == null ? 0 : this.getXrayEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaAuthorizerConfig() == null ? 0 : this.getLambdaAuthorizerConfig().hashCode());
        hashCode = 31 * hashCode + (this.getVisibility() == null ? 0 : this.getVisibility().hashCode());
        return hashCode;
    }

    public CreateGraphqlApiRequest clone() {
        return (CreateGraphqlApiRequest)super.clone();
    }
}

