/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.AppBlock;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AppBlockMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<StructuredPojo> SOURCES3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceS3Location").build();
    private static final MarshallingInfo<StructuredPojo> SETUPSCRIPTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SetupScriptDetails").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> POSTSETUPSCRIPTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostSetupScriptDetails").build();
    private static final MarshallingInfo<String> PACKAGINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackagingType").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<List> APPBLOCKERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppBlockErrors").build();
    private static final AppBlockMarshaller instance = new AppBlockMarshaller();

    public static AppBlockMarshaller getInstance() {
        return instance;
    }

    public void marshall(AppBlock appBlock, ProtocolMarshaller protocolMarshaller) {
        if (appBlock == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)appBlock.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getSourceS3Location(), SOURCES3LOCATION_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getSetupScriptDetails(), SETUPSCRIPTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getPostSetupScriptDetails(), POSTSETUPSCRIPTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getPackagingType(), PACKAGINGTYPE_BINDING);
            protocolMarshaller.marshall((Object)appBlock.getState(), STATE_BINDING);
            protocolMarshaller.marshall(appBlock.getAppBlockErrors(), APPBLOCKERRORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

