/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.PlatformType;
import com.amazonaws.services.appstream.model.S3Location;
import com.amazonaws.services.appstream.model.transform.ApplicationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Application
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String displayName;
    private String iconURL;
    private String launchPath;
    private String launchParameters;
    private Boolean enabled;
    private Map<String, String> metadata;
    private String workingDirectory;
    private String description;
    private String arn;
    private String appBlockArn;
    private S3Location iconS3Location;
    private List<String> platforms;
    private List<String> instanceFamilies;
    private Date createdTime;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Application withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Application withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setIconURL(String iconURL) {
        this.iconURL = iconURL;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public Application withIconURL(String iconURL) {
        this.setIconURL(iconURL);
        return this;
    }

    public void setLaunchPath(String launchPath) {
        this.launchPath = launchPath;
    }

    public String getLaunchPath() {
        return this.launchPath;
    }

    public Application withLaunchPath(String launchPath) {
        this.setLaunchPath(launchPath);
        return this;
    }

    public void setLaunchParameters(String launchParameters) {
        this.launchParameters = launchParameters;
    }

    public String getLaunchParameters() {
        return this.launchParameters;
    }

    public Application withLaunchParameters(String launchParameters) {
        this.setLaunchParameters(launchParameters);
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Application withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Application withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public Application addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public Application clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Application withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Application withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Application withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setAppBlockArn(String appBlockArn) {
        this.appBlockArn = appBlockArn;
    }

    public String getAppBlockArn() {
        return this.appBlockArn;
    }

    public Application withAppBlockArn(String appBlockArn) {
        this.setAppBlockArn(appBlockArn);
        return this;
    }

    public void setIconS3Location(S3Location iconS3Location) {
        this.iconS3Location = iconS3Location;
    }

    public S3Location getIconS3Location() {
        return this.iconS3Location;
    }

    public Application withIconS3Location(S3Location iconS3Location) {
        this.setIconS3Location(iconS3Location);
        return this;
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(Collection<String> platforms) {
        if (platforms == null) {
            this.platforms = null;
            return;
        }
        this.platforms = new ArrayList<String>(platforms);
    }

    public Application withPlatforms(String ... platforms) {
        if (this.platforms == null) {
            this.setPlatforms(new ArrayList<String>(platforms.length));
        }
        for (String ele : platforms) {
            this.platforms.add(ele);
        }
        return this;
    }

    public Application withPlatforms(Collection<String> platforms) {
        this.setPlatforms(platforms);
        return this;
    }

    public Application withPlatforms(PlatformType ... platforms) {
        ArrayList<String> platformsCopy = new ArrayList<String>(platforms.length);
        for (PlatformType value : platforms) {
            platformsCopy.add(value.toString());
        }
        if (this.getPlatforms() == null) {
            this.setPlatforms(platformsCopy);
        } else {
            this.getPlatforms().addAll(platformsCopy);
        }
        return this;
    }

    public List<String> getInstanceFamilies() {
        return this.instanceFamilies;
    }

    public void setInstanceFamilies(Collection<String> instanceFamilies) {
        if (instanceFamilies == null) {
            this.instanceFamilies = null;
            return;
        }
        this.instanceFamilies = new ArrayList<String>(instanceFamilies);
    }

    public Application withInstanceFamilies(String ... instanceFamilies) {
        if (this.instanceFamilies == null) {
            this.setInstanceFamilies(new ArrayList<String>(instanceFamilies.length));
        }
        for (String ele : instanceFamilies) {
            this.instanceFamilies.add(ele);
        }
        return this;
    }

    public Application withInstanceFamilies(Collection<String> instanceFamilies) {
        this.setInstanceFamilies(instanceFamilies);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Application withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getIconURL() != null) {
            sb.append("IconURL: ").append(this.getIconURL()).append(",");
        }
        if (this.getLaunchPath() != null) {
            sb.append("LaunchPath: ").append(this.getLaunchPath()).append(",");
        }
        if (this.getLaunchParameters() != null) {
            sb.append("LaunchParameters: ").append(this.getLaunchParameters()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAppBlockArn() != null) {
            sb.append("AppBlockArn: ").append(this.getAppBlockArn()).append(",");
        }
        if (this.getIconS3Location() != null) {
            sb.append("IconS3Location: ").append(this.getIconS3Location()).append(",");
        }
        if (this.getPlatforms() != null) {
            sb.append("Platforms: ").append(this.getPlatforms()).append(",");
        }
        if (this.getInstanceFamilies() != null) {
            sb.append("InstanceFamilies: ").append(this.getInstanceFamilies()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getIconURL() == null ^ this.getIconURL() == null) {
            return false;
        }
        if (other.getIconURL() != null && !other.getIconURL().equals(this.getIconURL())) {
            return false;
        }
        if (other.getLaunchPath() == null ^ this.getLaunchPath() == null) {
            return false;
        }
        if (other.getLaunchPath() != null && !other.getLaunchPath().equals(this.getLaunchPath())) {
            return false;
        }
        if (other.getLaunchParameters() == null ^ this.getLaunchParameters() == null) {
            return false;
        }
        if (other.getLaunchParameters() != null && !other.getLaunchParameters().equals(this.getLaunchParameters())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAppBlockArn() == null ^ this.getAppBlockArn() == null) {
            return false;
        }
        if (other.getAppBlockArn() != null && !other.getAppBlockArn().equals(this.getAppBlockArn())) {
            return false;
        }
        if (other.getIconS3Location() == null ^ this.getIconS3Location() == null) {
            return false;
        }
        if (other.getIconS3Location() != null && !other.getIconS3Location().equals(this.getIconS3Location())) {
            return false;
        }
        if (other.getPlatforms() == null ^ this.getPlatforms() == null) {
            return false;
        }
        if (other.getPlatforms() != null && !other.getPlatforms().equals(this.getPlatforms())) {
            return false;
        }
        if (other.getInstanceFamilies() == null ^ this.getInstanceFamilies() == null) {
            return false;
        }
        if (other.getInstanceFamilies() != null && !other.getInstanceFamilies().equals(this.getInstanceFamilies())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        return other.getCreatedTime() == null || other.getCreatedTime().equals(this.getCreatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getIconURL() == null ? 0 : this.getIconURL().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPath() == null ? 0 : this.getLaunchPath().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchParameters() == null ? 0 : this.getLaunchParameters().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAppBlockArn() == null ? 0 : this.getAppBlockArn().hashCode());
        hashCode = 31 * hashCode + (this.getIconS3Location() == null ? 0 : this.getIconS3Location().hashCode());
        hashCode = 31 * hashCode + (this.getPlatforms() == null ? 0 : this.getPlatforms().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFamilies() == null ? 0 : this.getInstanceFamilies().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        return hashCode;
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

