/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Application
implements Serializable,
Cloneable {
    private String name;
    private String displayName;
    private String iconURL;
    private String launchPath;
    private String launchParameters;
    private Boolean enabled;
    private Map<String, String> metadata;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Application withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Application withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setIconURL(String iconURL) {
        this.iconURL = iconURL;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public Application withIconURL(String iconURL) {
        this.setIconURL(iconURL);
        return this;
    }

    public void setLaunchPath(String launchPath) {
        this.launchPath = launchPath;
    }

    public String getLaunchPath() {
        return this.launchPath;
    }

    public Application withLaunchPath(String launchPath) {
        this.setLaunchPath(launchPath);
        return this;
    }

    public void setLaunchParameters(String launchParameters) {
        this.launchParameters = launchParameters;
    }

    public String getLaunchParameters() {
        return this.launchParameters;
    }

    public Application withLaunchParameters(String launchParameters) {
        this.setLaunchParameters(launchParameters);
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Application withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Application withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public Application addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public Application clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getIconURL() != null) {
            sb.append("IconURL: ").append(this.getIconURL()).append(",");
        }
        if (this.getLaunchPath() != null) {
            sb.append("LaunchPath: ").append(this.getLaunchPath()).append(",");
        }
        if (this.getLaunchParameters() != null) {
            sb.append("LaunchParameters: ").append(this.getLaunchParameters()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getIconURL() == null ^ this.getIconURL() == null) {
            return false;
        }
        if (other.getIconURL() != null && !other.getIconURL().equals(this.getIconURL())) {
            return false;
        }
        if (other.getLaunchPath() == null ^ this.getLaunchPath() == null) {
            return false;
        }
        if (other.getLaunchPath() != null && !other.getLaunchPath().equals(this.getLaunchPath())) {
            return false;
        }
        if (other.getLaunchParameters() == null ^ this.getLaunchParameters() == null) {
            return false;
        }
        if (other.getLaunchParameters() != null && !other.getLaunchParameters().equals(this.getLaunchParameters())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        return other.getMetadata() == null || other.getMetadata().equals(this.getMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getIconURL() == null ? 0 : this.getIconURL().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPath() == null ? 0 : this.getLaunchPath().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchParameters() == null ? 0 : this.getLaunchParameters().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        return hashCode;
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

