/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.ImageBuilder;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ImageBuilderMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> IMAGEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageArn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<StructuredPojo> STATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateChangeReason").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Boolean> ENABLEDEFAULTINTERNETACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableDefaultInternetAccess").build();
    private static final MarshallingInfo<StructuredPojo> DOMAINJOININFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainJoinInfo").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKACCESSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkAccessConfiguration").build();
    private static final MarshallingInfo<List> IMAGEBUILDERERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageBuilderErrors").build();
    private static final MarshallingInfo<String> APPSTREAMAGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppstreamAgentVersion").build();
    private static final ImageBuilderMarshaller instance = new ImageBuilderMarshaller();

    public static ImageBuilderMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageBuilder imageBuilder, ProtocolMarshaller protocolMarshaller) {
        if (imageBuilder == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageBuilder.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getImageArn(), IMAGEARN_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getVpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getStateChangeReason(), STATECHANGEREASON_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getEnableDefaultInternetAccess(), ENABLEDEFAULTINTERNETACCESS_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getDomainJoinInfo(), DOMAINJOININFO_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getNetworkAccessConfiguration(), NETWORKACCESSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(imageBuilder.getImageBuilderErrors(), IMAGEBUILDERERRORS_BINDING);
            protocolMarshaller.marshall((Object)imageBuilder.getAppstreamAgentVersion(), APPSTREAMAGENTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

