/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appstream.model.Stack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeStacksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Stack> stacks;
    private String nextToken;

    public List<Stack> getStacks() {
        return this.stacks;
    }

    public void setStacks(Collection<Stack> stacks) {
        if (stacks == null) {
            this.stacks = null;
            return;
        }
        this.stacks = new ArrayList<Stack>(stacks);
    }

    public DescribeStacksResult withStacks(Stack ... stacks) {
        if (this.stacks == null) {
            this.setStacks(new ArrayList<Stack>(stacks.length));
        }
        for (Stack ele : stacks) {
            this.stacks.add(ele);
        }
        return this;
    }

    public DescribeStacksResult withStacks(Collection<Stack> stacks) {
        this.setStacks(stacks);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeStacksResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStacks() != null) {
            sb.append("Stacks: ").append(this.getStacks()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResult)) {
            return false;
        }
        DescribeStacksResult other = (DescribeStacksResult)obj;
        if (other.getStacks() == null ^ this.getStacks() == null) {
            return false;
        }
        if (other.getStacks() != null && !other.getStacks().equals(this.getStacks())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStacks() == null ? 0 : this.getStacks().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeStacksResult clone() {
        try {
            return (DescribeStacksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

