/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.apprunner.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.apprunner.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeCustomDomainsResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeCustomDomainsResultJsonUnmarshaller implements Unmarshaller<DescribeCustomDomainsResult, JsonUnmarshallerContext> {

    public DescribeCustomDomainsResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeCustomDomainsResult describeCustomDomainsResult = new DescribeCustomDomainsResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeCustomDomainsResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DNSTarget", targetDepth)) {
                    context.nextToken();
                    describeCustomDomainsResult.setDNSTarget(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ServiceArn", targetDepth)) {
                    context.nextToken();
                    describeCustomDomainsResult.setServiceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CustomDomains", targetDepth)) {
                    context.nextToken();
                    describeCustomDomainsResult.setCustomDomains(new ListUnmarshaller<CustomDomain>(CustomDomainJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("VpcDNSTargets", targetDepth)) {
                    context.nextToken();
                    describeCustomDomainsResult.setVpcDNSTargets(new ListUnmarshaller<VpcDNSTarget>(VpcDNSTargetJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("NextToken", targetDepth)) {
                    context.nextToken();
                    describeCustomDomainsResult.setNextToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeCustomDomainsResult;
    }

    private static DescribeCustomDomainsResultJsonUnmarshaller instance;

    public static DescribeCustomDomainsResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DescribeCustomDomainsResultJsonUnmarshaller();
        return instance;
    }
}
