/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.JsonFormatRef;
import com.amazonaws.services.appmesh.model.transform.LoggingFormatMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoggingFormat
implements Serializable,
Cloneable,
StructuredPojo {
    private List<JsonFormatRef> json;
    private String text;

    public List<JsonFormatRef> getJson() {
        return this.json;
    }

    public void setJson(Collection<JsonFormatRef> json) {
        if (json == null) {
            this.json = null;
            return;
        }
        this.json = new ArrayList<JsonFormatRef>(json);
    }

    public LoggingFormat withJson(JsonFormatRef ... json) {
        if (this.json == null) {
            this.setJson(new ArrayList<JsonFormatRef>(json.length));
        }
        for (JsonFormatRef ele : json) {
            this.json.add(ele);
        }
        return this;
    }

    public LoggingFormat withJson(Collection<JsonFormatRef> json) {
        this.setJson(json);
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public LoggingFormat withText(String text) {
        this.setText(text);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJson() != null) {
            sb.append("Json: ").append(this.getJson()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingFormat)) {
            return false;
        }
        LoggingFormat other = (LoggingFormat)obj;
        if (other.getJson() == null ^ this.getJson() == null) {
            return false;
        }
        if (other.getJson() != null && !other.getJson().equals(this.getJson())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        return other.getText() == null || other.getText().equals(this.getText());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJson() == null ? 0 : this.getJson().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        return hashCode;
    }

    public LoggingFormat clone() {
        try {
            return (LoggingFormat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingFormatMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

