/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.HttpRetryPolicy;
import com.amazonaws.services.appmesh.model.HttpRouteAction;
import com.amazonaws.services.appmesh.model.HttpRouteMatch;
import com.amazonaws.services.appmesh.model.HttpTimeout;
import com.amazonaws.services.appmesh.model.transform.HttpRouteMarshaller;
import java.io.Serializable;

public class HttpRoute
implements Serializable,
Cloneable,
StructuredPojo {
    private HttpRouteAction action;
    private HttpRouteMatch match;
    private HttpRetryPolicy retryPolicy;
    private HttpTimeout timeout;

    public void setAction(HttpRouteAction action) {
        this.action = action;
    }

    public HttpRouteAction getAction() {
        return this.action;
    }

    public HttpRoute withAction(HttpRouteAction action) {
        this.setAction(action);
        return this;
    }

    public void setMatch(HttpRouteMatch match) {
        this.match = match;
    }

    public HttpRouteMatch getMatch() {
        return this.match;
    }

    public HttpRoute withMatch(HttpRouteMatch match) {
        this.setMatch(match);
        return this;
    }

    public void setRetryPolicy(HttpRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public HttpRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public HttpRoute withRetryPolicy(HttpRetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
        return this;
    }

    public void setTimeout(HttpTimeout timeout) {
        this.timeout = timeout;
    }

    public HttpTimeout getTimeout() {
        return this.timeout;
    }

    public HttpRoute withTimeout(HttpTimeout timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getMatch() != null) {
            sb.append("Match: ").append(this.getMatch()).append(",");
        }
        if (this.getRetryPolicy() != null) {
            sb.append("RetryPolicy: ").append(this.getRetryPolicy()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRoute)) {
            return false;
        }
        HttpRoute other = (HttpRoute)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getMatch() == null ^ this.getMatch() == null) {
            return false;
        }
        if (other.getMatch() != null && !other.getMatch().equals(this.getMatch())) {
            return false;
        }
        if (other.getRetryPolicy() == null ^ this.getRetryPolicy() == null) {
            return false;
        }
        if (other.getRetryPolicy() != null && !other.getRetryPolicy().equals(this.getRetryPolicy())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        return other.getTimeout() == null || other.getTimeout().equals(this.getTimeout());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getMatch() == null ? 0 : this.getMatch().hashCode());
        hashCode = 31 * hashCode + (this.getRetryPolicy() == null ? 0 : this.getRetryPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        return hashCode;
    }

    public HttpRoute clone() {
        try {
            return (HttpRoute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpRouteMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

