/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.Backend;
import com.amazonaws.services.appmesh.model.BackendDefaults;
import com.amazonaws.services.appmesh.model.Listener;
import com.amazonaws.services.appmesh.model.Logging;
import com.amazonaws.services.appmesh.model.ServiceDiscovery;
import com.amazonaws.services.appmesh.model.transform.VirtualNodeSpecMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VirtualNodeSpec
implements Serializable,
Cloneable,
StructuredPojo {
    private BackendDefaults backendDefaults;
    private List<Backend> backends;
    private List<Listener> listeners;
    private Logging logging;
    private ServiceDiscovery serviceDiscovery;

    public void setBackendDefaults(BackendDefaults backendDefaults) {
        this.backendDefaults = backendDefaults;
    }

    public BackendDefaults getBackendDefaults() {
        return this.backendDefaults;
    }

    public VirtualNodeSpec withBackendDefaults(BackendDefaults backendDefaults) {
        this.setBackendDefaults(backendDefaults);
        return this;
    }

    public List<Backend> getBackends() {
        return this.backends;
    }

    public void setBackends(Collection<Backend> backends) {
        if (backends == null) {
            this.backends = null;
            return;
        }
        this.backends = new ArrayList<Backend>(backends);
    }

    public VirtualNodeSpec withBackends(Backend ... backends) {
        if (this.backends == null) {
            this.setBackends(new ArrayList<Backend>(backends.length));
        }
        for (Backend ele : backends) {
            this.backends.add(ele);
        }
        return this;
    }

    public VirtualNodeSpec withBackends(Collection<Backend> backends) {
        this.setBackends(backends);
        return this;
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        if (listeners == null) {
            this.listeners = null;
            return;
        }
        this.listeners = new ArrayList<Listener>(listeners);
    }

    public VirtualNodeSpec withListeners(Listener ... listeners) {
        if (this.listeners == null) {
            this.setListeners(new ArrayList<Listener>(listeners.length));
        }
        for (Listener ele : listeners) {
            this.listeners.add(ele);
        }
        return this;
    }

    public VirtualNodeSpec withListeners(Collection<Listener> listeners) {
        this.setListeners(listeners);
        return this;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public VirtualNodeSpec withLogging(Logging logging) {
        this.setLogging(logging);
        return this;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public VirtualNodeSpec withServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.setServiceDiscovery(serviceDiscovery);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBackendDefaults() != null) {
            sb.append("BackendDefaults: ").append(this.getBackendDefaults()).append(",");
        }
        if (this.getBackends() != null) {
            sb.append("Backends: ").append(this.getBackends()).append(",");
        }
        if (this.getListeners() != null) {
            sb.append("Listeners: ").append(this.getListeners()).append(",");
        }
        if (this.getLogging() != null) {
            sb.append("Logging: ").append(this.getLogging()).append(",");
        }
        if (this.getServiceDiscovery() != null) {
            sb.append("ServiceDiscovery: ").append(this.getServiceDiscovery());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeSpec)) {
            return false;
        }
        VirtualNodeSpec other = (VirtualNodeSpec)obj;
        if (other.getBackendDefaults() == null ^ this.getBackendDefaults() == null) {
            return false;
        }
        if (other.getBackendDefaults() != null && !other.getBackendDefaults().equals(this.getBackendDefaults())) {
            return false;
        }
        if (other.getBackends() == null ^ this.getBackends() == null) {
            return false;
        }
        if (other.getBackends() != null && !other.getBackends().equals(this.getBackends())) {
            return false;
        }
        if (other.getListeners() == null ^ this.getListeners() == null) {
            return false;
        }
        if (other.getListeners() != null && !other.getListeners().equals(this.getListeners())) {
            return false;
        }
        if (other.getLogging() == null ^ this.getLogging() == null) {
            return false;
        }
        if (other.getLogging() != null && !other.getLogging().equals(this.getLogging())) {
            return false;
        }
        if (other.getServiceDiscovery() == null ^ this.getServiceDiscovery() == null) {
            return false;
        }
        return other.getServiceDiscovery() == null || other.getServiceDiscovery().equals(this.getServiceDiscovery());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBackendDefaults() == null ? 0 : this.getBackendDefaults().hashCode());
        hashCode = 31 * hashCode + (this.getBackends() == null ? 0 : this.getBackends().hashCode());
        hashCode = 31 * hashCode + (this.getListeners() == null ? 0 : this.getListeners().hashCode());
        hashCode = 31 * hashCode + (this.getLogging() == null ? 0 : this.getLogging().hashCode());
        hashCode = 31 * hashCode + (this.getServiceDiscovery() == null ? 0 : this.getServiceDiscovery().hashCode());
        return hashCode;
    }

    public VirtualNodeSpec clone() {
        try {
            return (VirtualNodeSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VirtualNodeSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

