/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationsignals.model.MetricReference;
import com.amazonaws.services.applicationsignals.model.transform.ServiceDependencyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceDependency
implements Serializable,
Cloneable,
StructuredPojo {
    private String operationName;
    private Map<String, String> dependencyKeyAttributes;
    private String dependencyOperationName;
    private List<MetricReference> metricReferences;

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ServiceDependency withOperationName(String operationName) {
        this.setOperationName(operationName);
        return this;
    }

    public Map<String, String> getDependencyKeyAttributes() {
        return this.dependencyKeyAttributes;
    }

    public void setDependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
        this.dependencyKeyAttributes = dependencyKeyAttributes;
    }

    public ServiceDependency withDependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
        this.setDependencyKeyAttributes(dependencyKeyAttributes);
        return this;
    }

    public ServiceDependency addDependencyKeyAttributesEntry(String key, String value) {
        if (null == this.dependencyKeyAttributes) {
            this.dependencyKeyAttributes = new HashMap<String, String>();
        }
        if (this.dependencyKeyAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dependencyKeyAttributes.put(key, value);
        return this;
    }

    public ServiceDependency clearDependencyKeyAttributesEntries() {
        this.dependencyKeyAttributes = null;
        return this;
    }

    public void setDependencyOperationName(String dependencyOperationName) {
        this.dependencyOperationName = dependencyOperationName;
    }

    public String getDependencyOperationName() {
        return this.dependencyOperationName;
    }

    public ServiceDependency withDependencyOperationName(String dependencyOperationName) {
        this.setDependencyOperationName(dependencyOperationName);
        return this;
    }

    public List<MetricReference> getMetricReferences() {
        return this.metricReferences;
    }

    public void setMetricReferences(Collection<MetricReference> metricReferences) {
        if (metricReferences == null) {
            this.metricReferences = null;
            return;
        }
        this.metricReferences = new ArrayList<MetricReference>(metricReferences);
    }

    public ServiceDependency withMetricReferences(MetricReference ... metricReferences) {
        if (this.metricReferences == null) {
            this.setMetricReferences(new ArrayList<MetricReference>(metricReferences.length));
        }
        for (MetricReference ele : metricReferences) {
            this.metricReferences.add(ele);
        }
        return this;
    }

    public ServiceDependency withMetricReferences(Collection<MetricReference> metricReferences) {
        this.setMetricReferences(metricReferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperationName() != null) {
            sb.append("OperationName: ").append(this.getOperationName()).append(",");
        }
        if (this.getDependencyKeyAttributes() != null) {
            sb.append("DependencyKeyAttributes: ").append(this.getDependencyKeyAttributes()).append(",");
        }
        if (this.getDependencyOperationName() != null) {
            sb.append("DependencyOperationName: ").append(this.getDependencyOperationName()).append(",");
        }
        if (this.getMetricReferences() != null) {
            sb.append("MetricReferences: ").append(this.getMetricReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDependency)) {
            return false;
        }
        ServiceDependency other = (ServiceDependency)obj;
        if (other.getOperationName() == null ^ this.getOperationName() == null) {
            return false;
        }
        if (other.getOperationName() != null && !other.getOperationName().equals(this.getOperationName())) {
            return false;
        }
        if (other.getDependencyKeyAttributes() == null ^ this.getDependencyKeyAttributes() == null) {
            return false;
        }
        if (other.getDependencyKeyAttributes() != null && !other.getDependencyKeyAttributes().equals(this.getDependencyKeyAttributes())) {
            return false;
        }
        if (other.getDependencyOperationName() == null ^ this.getDependencyOperationName() == null) {
            return false;
        }
        if (other.getDependencyOperationName() != null && !other.getDependencyOperationName().equals(this.getDependencyOperationName())) {
            return false;
        }
        if (other.getMetricReferences() == null ^ this.getMetricReferences() == null) {
            return false;
        }
        return other.getMetricReferences() == null || other.getMetricReferences().equals(this.getMetricReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperationName() == null ? 0 : this.getOperationName().hashCode());
        hashCode = 31 * hashCode + (this.getDependencyKeyAttributes() == null ? 0 : this.getDependencyKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getDependencyOperationName() == null ? 0 : this.getDependencyOperationName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricReferences() == null ? 0 : this.getMetricReferences().hashCode());
        return hashCode;
    }

    public ServiceDependency clone() {
        try {
            return (ServiceDependency)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceDependencyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

