/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationsignals.model.MetricReference;
import com.amazonaws.services.applicationsignals.model.transform.ServiceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Service
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> keyAttributes;
    private List<Map<String, String>> attributeMaps;
    private List<MetricReference> metricReferences;

    public Map<String, String> getKeyAttributes() {
        return this.keyAttributes;
    }

    public void setKeyAttributes(Map<String, String> keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    public Service withKeyAttributes(Map<String, String> keyAttributes) {
        this.setKeyAttributes(keyAttributes);
        return this;
    }

    public Service addKeyAttributesEntry(String key, String value) {
        if (null == this.keyAttributes) {
            this.keyAttributes = new HashMap<String, String>();
        }
        if (this.keyAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.keyAttributes.put(key, value);
        return this;
    }

    public Service clearKeyAttributesEntries() {
        this.keyAttributes = null;
        return this;
    }

    public List<Map<String, String>> getAttributeMaps() {
        return this.attributeMaps;
    }

    public void setAttributeMaps(Collection<Map<String, String>> attributeMaps) {
        if (attributeMaps == null) {
            this.attributeMaps = null;
            return;
        }
        this.attributeMaps = new ArrayList<Map<String, String>>(attributeMaps);
    }

    public Service withAttributeMaps(Map<String, String> ... attributeMaps) {
        if (this.attributeMaps == null) {
            this.setAttributeMaps(new ArrayList<Map<String, String>>(attributeMaps.length));
        }
        for (Map<String, String> ele : attributeMaps) {
            this.attributeMaps.add(ele);
        }
        return this;
    }

    public Service withAttributeMaps(Collection<Map<String, String>> attributeMaps) {
        this.setAttributeMaps(attributeMaps);
        return this;
    }

    public List<MetricReference> getMetricReferences() {
        return this.metricReferences;
    }

    public void setMetricReferences(Collection<MetricReference> metricReferences) {
        if (metricReferences == null) {
            this.metricReferences = null;
            return;
        }
        this.metricReferences = new ArrayList<MetricReference>(metricReferences);
    }

    public Service withMetricReferences(MetricReference ... metricReferences) {
        if (this.metricReferences == null) {
            this.setMetricReferences(new ArrayList<MetricReference>(metricReferences.length));
        }
        for (MetricReference ele : metricReferences) {
            this.metricReferences.add(ele);
        }
        return this;
    }

    public Service withMetricReferences(Collection<MetricReference> metricReferences) {
        this.setMetricReferences(metricReferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyAttributes() != null) {
            sb.append("KeyAttributes: ").append(this.getKeyAttributes()).append(",");
        }
        if (this.getAttributeMaps() != null) {
            sb.append("AttributeMaps: ").append(this.getAttributeMaps()).append(",");
        }
        if (this.getMetricReferences() != null) {
            sb.append("MetricReferences: ").append(this.getMetricReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (other.getKeyAttributes() == null ^ this.getKeyAttributes() == null) {
            return false;
        }
        if (other.getKeyAttributes() != null && !other.getKeyAttributes().equals(this.getKeyAttributes())) {
            return false;
        }
        if (other.getAttributeMaps() == null ^ this.getAttributeMaps() == null) {
            return false;
        }
        if (other.getAttributeMaps() != null && !other.getAttributeMaps().equals(this.getAttributeMaps())) {
            return false;
        }
        if (other.getMetricReferences() == null ^ this.getMetricReferences() == null) {
            return false;
        }
        return other.getMetricReferences() == null || other.getMetricReferences().equals(this.getMetricReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyAttributes() == null ? 0 : this.getKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeMaps() == null ? 0 : this.getAttributeMaps().hashCode());
        hashCode = 31 * hashCode + (this.getMetricReferences() == null ? 0 : this.getMetricReferences().hashCode());
        return hashCode;
    }

    public Service clone() {
        try {
            return (Service)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

