/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationautoscaling.model.TargetTrackingMetricDimension;
import com.amazonaws.services.applicationautoscaling.model.transform.TargetTrackingMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TargetTrackingMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TargetTrackingMetricDimension> dimensions;
    private String metricName;
    private String namespace;

    public List<TargetTrackingMetricDimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<TargetTrackingMetricDimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<TargetTrackingMetricDimension>(dimensions);
    }

    public TargetTrackingMetric withDimensions(TargetTrackingMetricDimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<TargetTrackingMetricDimension>(dimensions.length));
        }
        for (TargetTrackingMetricDimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public TargetTrackingMetric withDimensions(Collection<TargetTrackingMetricDimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public TargetTrackingMetric withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public TargetTrackingMetric withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingMetric)) {
            return false;
        }
        TargetTrackingMetric other = (TargetTrackingMetric)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        return other.getNamespace() == null || other.getNamespace().equals(this.getNamespace());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return hashCode;
    }

    public TargetTrackingMetric clone() {
        try {
            return (TargetTrackingMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetTrackingMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

