/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appintegrations.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appintegrations.model.transform.FileConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> folders;
    private Map<String, List<String>> filters;

    public List<String> getFolders() {
        return this.folders;
    }

    public void setFolders(Collection<String> folders) {
        if (folders == null) {
            this.folders = null;
            return;
        }
        this.folders = new ArrayList<String>(folders);
    }

    public FileConfiguration withFolders(String ... folders) {
        if (this.folders == null) {
            this.setFolders(new ArrayList<String>(folders.length));
        }
        for (String ele : folders) {
            this.folders.add(ele);
        }
        return this;
    }

    public FileConfiguration withFolders(Collection<String> folders) {
        this.setFolders(folders);
        return this;
    }

    public Map<String, List<String>> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, List<String>> filters) {
        this.filters = filters;
    }

    public FileConfiguration withFilters(Map<String, List<String>> filters) {
        this.setFilters(filters);
        return this;
    }

    public FileConfiguration addFiltersEntry(String key, List<String> value) {
        if (null == this.filters) {
            this.filters = new HashMap<String, List<String>>();
        }
        if (this.filters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.filters.put(key, value);
        return this;
    }

    public FileConfiguration clearFiltersEntries() {
        this.filters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFolders() != null) {
            sb.append("Folders: ").append(this.getFolders()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileConfiguration)) {
            return false;
        }
        FileConfiguration other = (FileConfiguration)obj;
        if (other.getFolders() == null ^ this.getFolders() == null) {
            return false;
        }
        if (other.getFolders() != null && !other.getFolders().equals(this.getFolders())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFolders() == null ? 0 : this.getFolders().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public FileConfiguration clone() {
        try {
            return (FileConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

