/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appintegrations;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.appintegrations.AmazonAppIntegrations;
import com.amazonaws.services.appintegrations.AmazonAppIntegrationsClientBuilder;
import com.amazonaws.services.appintegrations.model.AmazonAppIntegrationsException;
import com.amazonaws.services.appintegrations.model.CreateDataIntegrationRequest;
import com.amazonaws.services.appintegrations.model.CreateDataIntegrationResult;
import com.amazonaws.services.appintegrations.model.CreateEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.CreateEventIntegrationResult;
import com.amazonaws.services.appintegrations.model.DeleteDataIntegrationRequest;
import com.amazonaws.services.appintegrations.model.DeleteDataIntegrationResult;
import com.amazonaws.services.appintegrations.model.DeleteEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.DeleteEventIntegrationResult;
import com.amazonaws.services.appintegrations.model.GetDataIntegrationRequest;
import com.amazonaws.services.appintegrations.model.GetDataIntegrationResult;
import com.amazonaws.services.appintegrations.model.GetEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.GetEventIntegrationResult;
import com.amazonaws.services.appintegrations.model.ListDataIntegrationAssociationsRequest;
import com.amazonaws.services.appintegrations.model.ListDataIntegrationAssociationsResult;
import com.amazonaws.services.appintegrations.model.ListDataIntegrationsRequest;
import com.amazonaws.services.appintegrations.model.ListDataIntegrationsResult;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationAssociationsRequest;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationAssociationsResult;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationsRequest;
import com.amazonaws.services.appintegrations.model.ListEventIntegrationsResult;
import com.amazonaws.services.appintegrations.model.ListTagsForResourceRequest;
import com.amazonaws.services.appintegrations.model.ListTagsForResourceResult;
import com.amazonaws.services.appintegrations.model.TagResourceRequest;
import com.amazonaws.services.appintegrations.model.TagResourceResult;
import com.amazonaws.services.appintegrations.model.UntagResourceRequest;
import com.amazonaws.services.appintegrations.model.UntagResourceResult;
import com.amazonaws.services.appintegrations.model.UpdateDataIntegrationRequest;
import com.amazonaws.services.appintegrations.model.UpdateDataIntegrationResult;
import com.amazonaws.services.appintegrations.model.UpdateEventIntegrationRequest;
import com.amazonaws.services.appintegrations.model.UpdateEventIntegrationResult;
import com.amazonaws.services.appintegrations.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.CreateDataIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.CreateDataIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.CreateEventIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.CreateEventIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.DeleteDataIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.DeleteDataIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.DeleteEventIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.DeleteEventIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.DuplicateResourceExceptionUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.GetDataIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.GetDataIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.GetEventIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.GetEventIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.InternalServiceErrorExceptionUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListDataIntegrationAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListDataIntegrationAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListDataIntegrationsRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListDataIntegrationsResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListEventIntegrationAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListEventIntegrationAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListEventIntegrationsRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListEventIntegrationsResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ResourceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.UpdateDataIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.UpdateDataIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.appintegrations.model.transform.UpdateEventIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.transform.UpdateEventIntegrationResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonAppIntegrationsClient
extends AmazonWebServiceClient
implements AmazonAppIntegrations {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonAppIntegrations.class);
    private static final String DEFAULT_SIGNING_NAME = "app-integrations";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceError").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateResourceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DuplicateResourceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonAppIntegrationsException.class));

    public static AmazonAppIntegrationsClientBuilder builder() {
        return AmazonAppIntegrationsClientBuilder.standard();
    }

    AmazonAppIntegrationsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonAppIntegrationsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("app-integrations.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/appintegrations/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/appintegrations/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDataIntegrationResult createDataIntegration(CreateDataIntegrationRequest request) {
        request = (CreateDataIntegrationRequest)this.beforeClientExecution(request);
        return this.executeCreateDataIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataIntegrationResult executeCreateDataIntegration(CreateDataIntegrationRequest createDataIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataIntegrationRequestProtocolMarshaller(protocolFactory).marshall((CreateDataIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataIntegrationResult createDataIntegrationResult = (CreateDataIntegrationResult)response.getAwsResponse();
            return createDataIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateEventIntegrationResult createEventIntegration(CreateEventIntegrationRequest request) {
        request = (CreateEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executeCreateEventIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEventIntegrationResult executeCreateEventIntegration(CreateEventIntegrationRequest createEventIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEventIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEventIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEventIntegrationRequestProtocolMarshaller(protocolFactory).marshall((CreateEventIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEventIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEventIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEventIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEventIntegrationResult createEventIntegrationResult = (CreateEventIntegrationResult)response.getAwsResponse();
            return createEventIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataIntegrationResult deleteDataIntegration(DeleteDataIntegrationRequest request) {
        request = (DeleteDataIntegrationRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataIntegrationResult executeDeleteDataIntegration(DeleteDataIntegrationRequest deleteDataIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataIntegrationRequestProtocolMarshaller(protocolFactory).marshall((DeleteDataIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDataIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataIntegrationResult deleteDataIntegrationResult = (DeleteDataIntegrationResult)response.getAwsResponse();
            return deleteDataIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEventIntegrationResult deleteEventIntegration(DeleteEventIntegrationRequest request) {
        request = (DeleteEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executeDeleteEventIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEventIntegrationResult executeDeleteEventIntegration(DeleteEventIntegrationRequest deleteEventIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEventIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEventIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEventIntegrationRequestProtocolMarshaller(protocolFactory).marshall((DeleteEventIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEventIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEventIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEventIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEventIntegrationResult deleteEventIntegrationResult = (DeleteEventIntegrationResult)response.getAwsResponse();
            return deleteEventIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataIntegrationResult getDataIntegration(GetDataIntegrationRequest request) {
        request = (GetDataIntegrationRequest)this.beforeClientExecution(request);
        return this.executeGetDataIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataIntegrationResult executeGetDataIntegration(GetDataIntegrationRequest getDataIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataIntegrationRequestProtocolMarshaller(protocolFactory).marshall((GetDataIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataIntegrationResult getDataIntegrationResult = (GetDataIntegrationResult)response.getAwsResponse();
            return getDataIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEventIntegrationResult getEventIntegration(GetEventIntegrationRequest request) {
        request = (GetEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executeGetEventIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEventIntegrationResult executeGetEventIntegration(GetEventIntegrationRequest getEventIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEventIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEventIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEventIntegrationRequestProtocolMarshaller(protocolFactory).marshall((GetEventIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEventIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEventIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEventIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEventIntegrationResult getEventIntegrationResult = (GetEventIntegrationResult)response.getAwsResponse();
            return getEventIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataIntegrationAssociationsResult listDataIntegrationAssociations(ListDataIntegrationAssociationsRequest request) {
        request = (ListDataIntegrationAssociationsRequest)this.beforeClientExecution(request);
        return this.executeListDataIntegrationAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataIntegrationAssociationsResult executeListDataIntegrationAssociations(ListDataIntegrationAssociationsRequest listDataIntegrationAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataIntegrationAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataIntegrationAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataIntegrationAssociationsRequestProtocolMarshaller(protocolFactory).marshall((ListDataIntegrationAssociationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataIntegrationAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataIntegrationAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataIntegrationAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataIntegrationAssociationsResult listDataIntegrationAssociationsResult = (ListDataIntegrationAssociationsResult)response.getAwsResponse();
            return listDataIntegrationAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataIntegrationsResult listDataIntegrations(ListDataIntegrationsRequest request) {
        request = (ListDataIntegrationsRequest)this.beforeClientExecution(request);
        return this.executeListDataIntegrations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataIntegrationsResult executeListDataIntegrations(ListDataIntegrationsRequest listDataIntegrationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataIntegrationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataIntegrationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataIntegrationsRequestProtocolMarshaller(protocolFactory).marshall((ListDataIntegrationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataIntegrationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataIntegrations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataIntegrationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataIntegrationsResult listDataIntegrationsResult = (ListDataIntegrationsResult)response.getAwsResponse();
            return listDataIntegrationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventIntegrationAssociationsResult listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest request) {
        request = (ListEventIntegrationAssociationsRequest)this.beforeClientExecution(request);
        return this.executeListEventIntegrationAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEventIntegrationAssociationsResult executeListEventIntegrationAssociations(ListEventIntegrationAssociationsRequest listEventIntegrationAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventIntegrationAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventIntegrationAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventIntegrationAssociationsRequestProtocolMarshaller(protocolFactory).marshall((ListEventIntegrationAssociationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventIntegrationAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEventIntegrationAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventIntegrationAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventIntegrationAssociationsResult listEventIntegrationAssociationsResult = (ListEventIntegrationAssociationsResult)response.getAwsResponse();
            return listEventIntegrationAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventIntegrationsResult listEventIntegrations(ListEventIntegrationsRequest request) {
        request = (ListEventIntegrationsRequest)this.beforeClientExecution(request);
        return this.executeListEventIntegrations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEventIntegrationsResult executeListEventIntegrations(ListEventIntegrationsRequest listEventIntegrationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventIntegrationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventIntegrationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventIntegrationsRequestProtocolMarshaller(protocolFactory).marshall((ListEventIntegrationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventIntegrationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEventIntegrations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventIntegrationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventIntegrationsResult listEventIntegrationsResult = (ListEventIntegrationsResult)response.getAwsResponse();
            return listEventIntegrationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDataIntegrationResult updateDataIntegration(UpdateDataIntegrationRequest request) {
        request = (UpdateDataIntegrationRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDataIntegrationResult executeUpdateDataIntegration(UpdateDataIntegrationRequest updateDataIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDataIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDataIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDataIntegrationRequestProtocolMarshaller(protocolFactory).marshall((UpdateDataIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDataIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDataIntegrationResult updateDataIntegrationResult = (UpdateDataIntegrationResult)response.getAwsResponse();
            return updateDataIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEventIntegrationResult updateEventIntegration(UpdateEventIntegrationRequest request) {
        request = (UpdateEventIntegrationRequest)this.beforeClientExecution(request);
        return this.executeUpdateEventIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEventIntegrationResult executeUpdateEventIntegration(UpdateEventIntegrationRequest updateEventIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEventIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEventIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEventIntegrationRequestProtocolMarshaller(protocolFactory).marshall((UpdateEventIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEventIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppIntegrations");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEventIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEventIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEventIntegrationResult updateEventIntegrationResult = (UpdateEventIntegrationResult)response.getAwsResponse();
            return updateEventIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

