/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.ExecutionRecord;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ExecutionRecordMarshaller {
    private static final MarshallingInfo<String> EXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionId").build();
    private static final MarshallingInfo<String> EXECUTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionStatus").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONRESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionResult").build();
    private static final MarshallingInfo<Date> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DATAPULLSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataPullStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DATAPULLENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataPullEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> METADATACATALOGDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadataCatalogDetails").build();
    private static final ExecutionRecordMarshaller instance = new ExecutionRecordMarshaller();

    public static ExecutionRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExecutionRecord executionRecord, ProtocolMarshaller protocolMarshaller) {
        if (executionRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)executionRecord.getExecutionId(), EXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)executionRecord.getExecutionStatus(), EXECUTIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)executionRecord.getExecutionResult(), EXECUTIONRESULT_BINDING);
            protocolMarshaller.marshall((Object)executionRecord.getStartedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)executionRecord.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)executionRecord.getDataPullStartTime(), DATAPULLSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)executionRecord.getDataPullEndTime(), DATAPULLENDTIME_BINDING);
            protocolMarshaller.marshall(executionRecord.getMetadataCatalogDetails(), METADATACATALOGDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

