/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.AuthenticationConfig;
import com.amazonaws.services.appflow.model.ConnectorMetadata;
import com.amazonaws.services.appflow.model.ConnectorProvisioningConfig;
import com.amazonaws.services.appflow.model.ConnectorProvisioningType;
import com.amazonaws.services.appflow.model.ConnectorRuntimeSetting;
import com.amazonaws.services.appflow.model.ConnectorType;
import com.amazonaws.services.appflow.model.Operators;
import com.amazonaws.services.appflow.model.ScheduleFrequencyType;
import com.amazonaws.services.appflow.model.TriggerType;
import com.amazonaws.services.appflow.model.WriteOperationType;
import com.amazonaws.services.appflow.model.transform.ConnectorConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ConnectorConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean canUseAsSource;
    private Boolean canUseAsDestination;
    private List<String> supportedDestinationConnectors;
    private List<String> supportedSchedulingFrequencies;
    private Boolean isPrivateLinkEnabled;
    private Boolean isPrivateLinkEndpointUrlRequired;
    private List<String> supportedTriggerTypes;
    private ConnectorMetadata connectorMetadata;
    private String connectorType;
    private String connectorLabel;
    private String connectorDescription;
    private String connectorOwner;
    private String connectorName;
    private String connectorVersion;
    private String connectorArn;
    private List<String> connectorModes;
    private AuthenticationConfig authenticationConfig;
    private List<ConnectorRuntimeSetting> connectorRuntimeSettings;
    private List<String> supportedApiVersions;
    private List<String> supportedOperators;
    private List<String> supportedWriteOperations;
    private String connectorProvisioningType;
    private ConnectorProvisioningConfig connectorProvisioningConfig;
    private String logoURL;
    private Date registeredAt;
    private String registeredBy;

    public void setCanUseAsSource(Boolean canUseAsSource) {
        this.canUseAsSource = canUseAsSource;
    }

    public Boolean getCanUseAsSource() {
        return this.canUseAsSource;
    }

    public ConnectorConfiguration withCanUseAsSource(Boolean canUseAsSource) {
        this.setCanUseAsSource(canUseAsSource);
        return this;
    }

    public Boolean isCanUseAsSource() {
        return this.canUseAsSource;
    }

    public void setCanUseAsDestination(Boolean canUseAsDestination) {
        this.canUseAsDestination = canUseAsDestination;
    }

    public Boolean getCanUseAsDestination() {
        return this.canUseAsDestination;
    }

    public ConnectorConfiguration withCanUseAsDestination(Boolean canUseAsDestination) {
        this.setCanUseAsDestination(canUseAsDestination);
        return this;
    }

    public Boolean isCanUseAsDestination() {
        return this.canUseAsDestination;
    }

    public List<String> getSupportedDestinationConnectors() {
        return this.supportedDestinationConnectors;
    }

    public void setSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
        if (supportedDestinationConnectors == null) {
            this.supportedDestinationConnectors = null;
            return;
        }
        this.supportedDestinationConnectors = new ArrayList<String>(supportedDestinationConnectors);
    }

    public ConnectorConfiguration withSupportedDestinationConnectors(String ... supportedDestinationConnectors) {
        if (this.supportedDestinationConnectors == null) {
            this.setSupportedDestinationConnectors(new ArrayList<String>(supportedDestinationConnectors.length));
        }
        for (String ele : supportedDestinationConnectors) {
            this.supportedDestinationConnectors.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
        this.setSupportedDestinationConnectors(supportedDestinationConnectors);
        return this;
    }

    public ConnectorConfiguration withSupportedDestinationConnectors(ConnectorType ... supportedDestinationConnectors) {
        ArrayList<String> supportedDestinationConnectorsCopy = new ArrayList<String>(supportedDestinationConnectors.length);
        for (ConnectorType value : supportedDestinationConnectors) {
            supportedDestinationConnectorsCopy.add(value.toString());
        }
        if (this.getSupportedDestinationConnectors() == null) {
            this.setSupportedDestinationConnectors(supportedDestinationConnectorsCopy);
        } else {
            this.getSupportedDestinationConnectors().addAll(supportedDestinationConnectorsCopy);
        }
        return this;
    }

    public List<String> getSupportedSchedulingFrequencies() {
        return this.supportedSchedulingFrequencies;
    }

    public void setSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
        if (supportedSchedulingFrequencies == null) {
            this.supportedSchedulingFrequencies = null;
            return;
        }
        this.supportedSchedulingFrequencies = new ArrayList<String>(supportedSchedulingFrequencies);
    }

    public ConnectorConfiguration withSupportedSchedulingFrequencies(String ... supportedSchedulingFrequencies) {
        if (this.supportedSchedulingFrequencies == null) {
            this.setSupportedSchedulingFrequencies(new ArrayList<String>(supportedSchedulingFrequencies.length));
        }
        for (String ele : supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
        this.setSupportedSchedulingFrequencies(supportedSchedulingFrequencies);
        return this;
    }

    public ConnectorConfiguration withSupportedSchedulingFrequencies(ScheduleFrequencyType ... supportedSchedulingFrequencies) {
        ArrayList<String> supportedSchedulingFrequenciesCopy = new ArrayList<String>(supportedSchedulingFrequencies.length);
        for (ScheduleFrequencyType value : supportedSchedulingFrequencies) {
            supportedSchedulingFrequenciesCopy.add(value.toString());
        }
        if (this.getSupportedSchedulingFrequencies() == null) {
            this.setSupportedSchedulingFrequencies(supportedSchedulingFrequenciesCopy);
        } else {
            this.getSupportedSchedulingFrequencies().addAll(supportedSchedulingFrequenciesCopy);
        }
        return this;
    }

    public void setIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
        this.isPrivateLinkEnabled = isPrivateLinkEnabled;
    }

    public Boolean getIsPrivateLinkEnabled() {
        return this.isPrivateLinkEnabled;
    }

    public ConnectorConfiguration withIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
        this.setIsPrivateLinkEnabled(isPrivateLinkEnabled);
        return this;
    }

    public Boolean isPrivateLinkEnabled() {
        return this.isPrivateLinkEnabled;
    }

    public void setIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
        this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
    }

    public Boolean getIsPrivateLinkEndpointUrlRequired() {
        return this.isPrivateLinkEndpointUrlRequired;
    }

    public ConnectorConfiguration withIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
        this.setIsPrivateLinkEndpointUrlRequired(isPrivateLinkEndpointUrlRequired);
        return this;
    }

    public Boolean isPrivateLinkEndpointUrlRequired() {
        return this.isPrivateLinkEndpointUrlRequired;
    }

    public List<String> getSupportedTriggerTypes() {
        return this.supportedTriggerTypes;
    }

    public void setSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
        if (supportedTriggerTypes == null) {
            this.supportedTriggerTypes = null;
            return;
        }
        this.supportedTriggerTypes = new ArrayList<String>(supportedTriggerTypes);
    }

    public ConnectorConfiguration withSupportedTriggerTypes(String ... supportedTriggerTypes) {
        if (this.supportedTriggerTypes == null) {
            this.setSupportedTriggerTypes(new ArrayList<String>(supportedTriggerTypes.length));
        }
        for (String ele : supportedTriggerTypes) {
            this.supportedTriggerTypes.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
        this.setSupportedTriggerTypes(supportedTriggerTypes);
        return this;
    }

    public ConnectorConfiguration withSupportedTriggerTypes(TriggerType ... supportedTriggerTypes) {
        ArrayList<String> supportedTriggerTypesCopy = new ArrayList<String>(supportedTriggerTypes.length);
        for (TriggerType value : supportedTriggerTypes) {
            supportedTriggerTypesCopy.add(value.toString());
        }
        if (this.getSupportedTriggerTypes() == null) {
            this.setSupportedTriggerTypes(supportedTriggerTypesCopy);
        } else {
            this.getSupportedTriggerTypes().addAll(supportedTriggerTypesCopy);
        }
        return this;
    }

    public void setConnectorMetadata(ConnectorMetadata connectorMetadata) {
        this.connectorMetadata = connectorMetadata;
    }

    public ConnectorMetadata getConnectorMetadata() {
        return this.connectorMetadata;
    }

    public ConnectorConfiguration withConnectorMetadata(ConnectorMetadata connectorMetadata) {
        this.setConnectorMetadata(connectorMetadata);
        return this;
    }

    public void setConnectorType(String connectorType) {
        this.connectorType = connectorType;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public ConnectorConfiguration withConnectorType(String connectorType) {
        this.setConnectorType(connectorType);
        return this;
    }

    public ConnectorConfiguration withConnectorType(ConnectorType connectorType) {
        this.connectorType = connectorType.toString();
        return this;
    }

    public void setConnectorLabel(String connectorLabel) {
        this.connectorLabel = connectorLabel;
    }

    public String getConnectorLabel() {
        return this.connectorLabel;
    }

    public ConnectorConfiguration withConnectorLabel(String connectorLabel) {
        this.setConnectorLabel(connectorLabel);
        return this;
    }

    public void setConnectorDescription(String connectorDescription) {
        this.connectorDescription = connectorDescription;
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public ConnectorConfiguration withConnectorDescription(String connectorDescription) {
        this.setConnectorDescription(connectorDescription);
        return this;
    }

    public void setConnectorOwner(String connectorOwner) {
        this.connectorOwner = connectorOwner;
    }

    public String getConnectorOwner() {
        return this.connectorOwner;
    }

    public ConnectorConfiguration withConnectorOwner(String connectorOwner) {
        this.setConnectorOwner(connectorOwner);
        return this;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public ConnectorConfiguration withConnectorName(String connectorName) {
        this.setConnectorName(connectorName);
        return this;
    }

    public void setConnectorVersion(String connectorVersion) {
        this.connectorVersion = connectorVersion;
    }

    public String getConnectorVersion() {
        return this.connectorVersion;
    }

    public ConnectorConfiguration withConnectorVersion(String connectorVersion) {
        this.setConnectorVersion(connectorVersion);
        return this;
    }

    public void setConnectorArn(String connectorArn) {
        this.connectorArn = connectorArn;
    }

    public String getConnectorArn() {
        return this.connectorArn;
    }

    public ConnectorConfiguration withConnectorArn(String connectorArn) {
        this.setConnectorArn(connectorArn);
        return this;
    }

    public List<String> getConnectorModes() {
        return this.connectorModes;
    }

    public void setConnectorModes(Collection<String> connectorModes) {
        if (connectorModes == null) {
            this.connectorModes = null;
            return;
        }
        this.connectorModes = new ArrayList<String>(connectorModes);
    }

    public ConnectorConfiguration withConnectorModes(String ... connectorModes) {
        if (this.connectorModes == null) {
            this.setConnectorModes(new ArrayList<String>(connectorModes.length));
        }
        for (String ele : connectorModes) {
            this.connectorModes.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withConnectorModes(Collection<String> connectorModes) {
        this.setConnectorModes(connectorModes);
        return this;
    }

    public void setAuthenticationConfig(AuthenticationConfig authenticationConfig) {
        this.authenticationConfig = authenticationConfig;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public ConnectorConfiguration withAuthenticationConfig(AuthenticationConfig authenticationConfig) {
        this.setAuthenticationConfig(authenticationConfig);
        return this;
    }

    public List<ConnectorRuntimeSetting> getConnectorRuntimeSettings() {
        return this.connectorRuntimeSettings;
    }

    public void setConnectorRuntimeSettings(Collection<ConnectorRuntimeSetting> connectorRuntimeSettings) {
        if (connectorRuntimeSettings == null) {
            this.connectorRuntimeSettings = null;
            return;
        }
        this.connectorRuntimeSettings = new ArrayList<ConnectorRuntimeSetting>(connectorRuntimeSettings);
    }

    public ConnectorConfiguration withConnectorRuntimeSettings(ConnectorRuntimeSetting ... connectorRuntimeSettings) {
        if (this.connectorRuntimeSettings == null) {
            this.setConnectorRuntimeSettings(new ArrayList<ConnectorRuntimeSetting>(connectorRuntimeSettings.length));
        }
        for (ConnectorRuntimeSetting ele : connectorRuntimeSettings) {
            this.connectorRuntimeSettings.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withConnectorRuntimeSettings(Collection<ConnectorRuntimeSetting> connectorRuntimeSettings) {
        this.setConnectorRuntimeSettings(connectorRuntimeSettings);
        return this;
    }

    public List<String> getSupportedApiVersions() {
        return this.supportedApiVersions;
    }

    public void setSupportedApiVersions(Collection<String> supportedApiVersions) {
        if (supportedApiVersions == null) {
            this.supportedApiVersions = null;
            return;
        }
        this.supportedApiVersions = new ArrayList<String>(supportedApiVersions);
    }

    public ConnectorConfiguration withSupportedApiVersions(String ... supportedApiVersions) {
        if (this.supportedApiVersions == null) {
            this.setSupportedApiVersions(new ArrayList<String>(supportedApiVersions.length));
        }
        for (String ele : supportedApiVersions) {
            this.supportedApiVersions.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedApiVersions(Collection<String> supportedApiVersions) {
        this.setSupportedApiVersions(supportedApiVersions);
        return this;
    }

    public List<String> getSupportedOperators() {
        return this.supportedOperators;
    }

    public void setSupportedOperators(Collection<String> supportedOperators) {
        if (supportedOperators == null) {
            this.supportedOperators = null;
            return;
        }
        this.supportedOperators = new ArrayList<String>(supportedOperators);
    }

    public ConnectorConfiguration withSupportedOperators(String ... supportedOperators) {
        if (this.supportedOperators == null) {
            this.setSupportedOperators(new ArrayList<String>(supportedOperators.length));
        }
        for (String ele : supportedOperators) {
            this.supportedOperators.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedOperators(Collection<String> supportedOperators) {
        this.setSupportedOperators(supportedOperators);
        return this;
    }

    public ConnectorConfiguration withSupportedOperators(Operators ... supportedOperators) {
        ArrayList<String> supportedOperatorsCopy = new ArrayList<String>(supportedOperators.length);
        for (Operators value : supportedOperators) {
            supportedOperatorsCopy.add(value.toString());
        }
        if (this.getSupportedOperators() == null) {
            this.setSupportedOperators(supportedOperatorsCopy);
        } else {
            this.getSupportedOperators().addAll(supportedOperatorsCopy);
        }
        return this;
    }

    public List<String> getSupportedWriteOperations() {
        return this.supportedWriteOperations;
    }

    public void setSupportedWriteOperations(Collection<String> supportedWriteOperations) {
        if (supportedWriteOperations == null) {
            this.supportedWriteOperations = null;
            return;
        }
        this.supportedWriteOperations = new ArrayList<String>(supportedWriteOperations);
    }

    public ConnectorConfiguration withSupportedWriteOperations(String ... supportedWriteOperations) {
        if (this.supportedWriteOperations == null) {
            this.setSupportedWriteOperations(new ArrayList<String>(supportedWriteOperations.length));
        }
        for (String ele : supportedWriteOperations) {
            this.supportedWriteOperations.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedWriteOperations(Collection<String> supportedWriteOperations) {
        this.setSupportedWriteOperations(supportedWriteOperations);
        return this;
    }

    public ConnectorConfiguration withSupportedWriteOperations(WriteOperationType ... supportedWriteOperations) {
        ArrayList<String> supportedWriteOperationsCopy = new ArrayList<String>(supportedWriteOperations.length);
        for (WriteOperationType value : supportedWriteOperations) {
            supportedWriteOperationsCopy.add(value.toString());
        }
        if (this.getSupportedWriteOperations() == null) {
            this.setSupportedWriteOperations(supportedWriteOperationsCopy);
        } else {
            this.getSupportedWriteOperations().addAll(supportedWriteOperationsCopy);
        }
        return this;
    }

    public void setConnectorProvisioningType(String connectorProvisioningType) {
        this.connectorProvisioningType = connectorProvisioningType;
    }

    public String getConnectorProvisioningType() {
        return this.connectorProvisioningType;
    }

    public ConnectorConfiguration withConnectorProvisioningType(String connectorProvisioningType) {
        this.setConnectorProvisioningType(connectorProvisioningType);
        return this;
    }

    public ConnectorConfiguration withConnectorProvisioningType(ConnectorProvisioningType connectorProvisioningType) {
        this.connectorProvisioningType = connectorProvisioningType.toString();
        return this;
    }

    public void setConnectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig) {
        this.connectorProvisioningConfig = connectorProvisioningConfig;
    }

    public ConnectorProvisioningConfig getConnectorProvisioningConfig() {
        return this.connectorProvisioningConfig;
    }

    public ConnectorConfiguration withConnectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig) {
        this.setConnectorProvisioningConfig(connectorProvisioningConfig);
        return this;
    }

    public void setLogoURL(String logoURL) {
        this.logoURL = logoURL;
    }

    public String getLogoURL() {
        return this.logoURL;
    }

    public ConnectorConfiguration withLogoURL(String logoURL) {
        this.setLogoURL(logoURL);
        return this;
    }

    public void setRegisteredAt(Date registeredAt) {
        this.registeredAt = registeredAt;
    }

    public Date getRegisteredAt() {
        return this.registeredAt;
    }

    public ConnectorConfiguration withRegisteredAt(Date registeredAt) {
        this.setRegisteredAt(registeredAt);
        return this;
    }

    public void setRegisteredBy(String registeredBy) {
        this.registeredBy = registeredBy;
    }

    public String getRegisteredBy() {
        return this.registeredBy;
    }

    public ConnectorConfiguration withRegisteredBy(String registeredBy) {
        this.setRegisteredBy(registeredBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCanUseAsSource() != null) {
            sb.append("CanUseAsSource: ").append(this.getCanUseAsSource()).append(",");
        }
        if (this.getCanUseAsDestination() != null) {
            sb.append("CanUseAsDestination: ").append(this.getCanUseAsDestination()).append(",");
        }
        if (this.getSupportedDestinationConnectors() != null) {
            sb.append("SupportedDestinationConnectors: ").append(this.getSupportedDestinationConnectors()).append(",");
        }
        if (this.getSupportedSchedulingFrequencies() != null) {
            sb.append("SupportedSchedulingFrequencies: ").append(this.getSupportedSchedulingFrequencies()).append(",");
        }
        if (this.getIsPrivateLinkEnabled() != null) {
            sb.append("IsPrivateLinkEnabled: ").append(this.getIsPrivateLinkEnabled()).append(",");
        }
        if (this.getIsPrivateLinkEndpointUrlRequired() != null) {
            sb.append("IsPrivateLinkEndpointUrlRequired: ").append(this.getIsPrivateLinkEndpointUrlRequired()).append(",");
        }
        if (this.getSupportedTriggerTypes() != null) {
            sb.append("SupportedTriggerTypes: ").append(this.getSupportedTriggerTypes()).append(",");
        }
        if (this.getConnectorMetadata() != null) {
            sb.append("ConnectorMetadata: ").append(this.getConnectorMetadata()).append(",");
        }
        if (this.getConnectorType() != null) {
            sb.append("ConnectorType: ").append(this.getConnectorType()).append(",");
        }
        if (this.getConnectorLabel() != null) {
            sb.append("ConnectorLabel: ").append(this.getConnectorLabel()).append(",");
        }
        if (this.getConnectorDescription() != null) {
            sb.append("ConnectorDescription: ").append(this.getConnectorDescription()).append(",");
        }
        if (this.getConnectorOwner() != null) {
            sb.append("ConnectorOwner: ").append(this.getConnectorOwner()).append(",");
        }
        if (this.getConnectorName() != null) {
            sb.append("ConnectorName: ").append(this.getConnectorName()).append(",");
        }
        if (this.getConnectorVersion() != null) {
            sb.append("ConnectorVersion: ").append(this.getConnectorVersion()).append(",");
        }
        if (this.getConnectorArn() != null) {
            sb.append("ConnectorArn: ").append(this.getConnectorArn()).append(",");
        }
        if (this.getConnectorModes() != null) {
            sb.append("ConnectorModes: ").append(this.getConnectorModes()).append(",");
        }
        if (this.getAuthenticationConfig() != null) {
            sb.append("AuthenticationConfig: ").append(this.getAuthenticationConfig()).append(",");
        }
        if (this.getConnectorRuntimeSettings() != null) {
            sb.append("ConnectorRuntimeSettings: ").append(this.getConnectorRuntimeSettings()).append(",");
        }
        if (this.getSupportedApiVersions() != null) {
            sb.append("SupportedApiVersions: ").append(this.getSupportedApiVersions()).append(",");
        }
        if (this.getSupportedOperators() != null) {
            sb.append("SupportedOperators: ").append(this.getSupportedOperators()).append(",");
        }
        if (this.getSupportedWriteOperations() != null) {
            sb.append("SupportedWriteOperations: ").append(this.getSupportedWriteOperations()).append(",");
        }
        if (this.getConnectorProvisioningType() != null) {
            sb.append("ConnectorProvisioningType: ").append(this.getConnectorProvisioningType()).append(",");
        }
        if (this.getConnectorProvisioningConfig() != null) {
            sb.append("ConnectorProvisioningConfig: ").append(this.getConnectorProvisioningConfig()).append(",");
        }
        if (this.getLogoURL() != null) {
            sb.append("LogoURL: ").append(this.getLogoURL()).append(",");
        }
        if (this.getRegisteredAt() != null) {
            sb.append("RegisteredAt: ").append(this.getRegisteredAt()).append(",");
        }
        if (this.getRegisteredBy() != null) {
            sb.append("RegisteredBy: ").append(this.getRegisteredBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfiguration)) {
            return false;
        }
        ConnectorConfiguration other = (ConnectorConfiguration)obj;
        if (other.getCanUseAsSource() == null ^ this.getCanUseAsSource() == null) {
            return false;
        }
        if (other.getCanUseAsSource() != null && !other.getCanUseAsSource().equals(this.getCanUseAsSource())) {
            return false;
        }
        if (other.getCanUseAsDestination() == null ^ this.getCanUseAsDestination() == null) {
            return false;
        }
        if (other.getCanUseAsDestination() != null && !other.getCanUseAsDestination().equals(this.getCanUseAsDestination())) {
            return false;
        }
        if (other.getSupportedDestinationConnectors() == null ^ this.getSupportedDestinationConnectors() == null) {
            return false;
        }
        if (other.getSupportedDestinationConnectors() != null && !other.getSupportedDestinationConnectors().equals(this.getSupportedDestinationConnectors())) {
            return false;
        }
        if (other.getSupportedSchedulingFrequencies() == null ^ this.getSupportedSchedulingFrequencies() == null) {
            return false;
        }
        if (other.getSupportedSchedulingFrequencies() != null && !other.getSupportedSchedulingFrequencies().equals(this.getSupportedSchedulingFrequencies())) {
            return false;
        }
        if (other.getIsPrivateLinkEnabled() == null ^ this.getIsPrivateLinkEnabled() == null) {
            return false;
        }
        if (other.getIsPrivateLinkEnabled() != null && !other.getIsPrivateLinkEnabled().equals(this.getIsPrivateLinkEnabled())) {
            return false;
        }
        if (other.getIsPrivateLinkEndpointUrlRequired() == null ^ this.getIsPrivateLinkEndpointUrlRequired() == null) {
            return false;
        }
        if (other.getIsPrivateLinkEndpointUrlRequired() != null && !other.getIsPrivateLinkEndpointUrlRequired().equals(this.getIsPrivateLinkEndpointUrlRequired())) {
            return false;
        }
        if (other.getSupportedTriggerTypes() == null ^ this.getSupportedTriggerTypes() == null) {
            return false;
        }
        if (other.getSupportedTriggerTypes() != null && !other.getSupportedTriggerTypes().equals(this.getSupportedTriggerTypes())) {
            return false;
        }
        if (other.getConnectorMetadata() == null ^ this.getConnectorMetadata() == null) {
            return false;
        }
        if (other.getConnectorMetadata() != null && !other.getConnectorMetadata().equals(this.getConnectorMetadata())) {
            return false;
        }
        if (other.getConnectorType() == null ^ this.getConnectorType() == null) {
            return false;
        }
        if (other.getConnectorType() != null && !other.getConnectorType().equals(this.getConnectorType())) {
            return false;
        }
        if (other.getConnectorLabel() == null ^ this.getConnectorLabel() == null) {
            return false;
        }
        if (other.getConnectorLabel() != null && !other.getConnectorLabel().equals(this.getConnectorLabel())) {
            return false;
        }
        if (other.getConnectorDescription() == null ^ this.getConnectorDescription() == null) {
            return false;
        }
        if (other.getConnectorDescription() != null && !other.getConnectorDescription().equals(this.getConnectorDescription())) {
            return false;
        }
        if (other.getConnectorOwner() == null ^ this.getConnectorOwner() == null) {
            return false;
        }
        if (other.getConnectorOwner() != null && !other.getConnectorOwner().equals(this.getConnectorOwner())) {
            return false;
        }
        if (other.getConnectorName() == null ^ this.getConnectorName() == null) {
            return false;
        }
        if (other.getConnectorName() != null && !other.getConnectorName().equals(this.getConnectorName())) {
            return false;
        }
        if (other.getConnectorVersion() == null ^ this.getConnectorVersion() == null) {
            return false;
        }
        if (other.getConnectorVersion() != null && !other.getConnectorVersion().equals(this.getConnectorVersion())) {
            return false;
        }
        if (other.getConnectorArn() == null ^ this.getConnectorArn() == null) {
            return false;
        }
        if (other.getConnectorArn() != null && !other.getConnectorArn().equals(this.getConnectorArn())) {
            return false;
        }
        if (other.getConnectorModes() == null ^ this.getConnectorModes() == null) {
            return false;
        }
        if (other.getConnectorModes() != null && !other.getConnectorModes().equals(this.getConnectorModes())) {
            return false;
        }
        if (other.getAuthenticationConfig() == null ^ this.getAuthenticationConfig() == null) {
            return false;
        }
        if (other.getAuthenticationConfig() != null && !other.getAuthenticationConfig().equals(this.getAuthenticationConfig())) {
            return false;
        }
        if (other.getConnectorRuntimeSettings() == null ^ this.getConnectorRuntimeSettings() == null) {
            return false;
        }
        if (other.getConnectorRuntimeSettings() != null && !other.getConnectorRuntimeSettings().equals(this.getConnectorRuntimeSettings())) {
            return false;
        }
        if (other.getSupportedApiVersions() == null ^ this.getSupportedApiVersions() == null) {
            return false;
        }
        if (other.getSupportedApiVersions() != null && !other.getSupportedApiVersions().equals(this.getSupportedApiVersions())) {
            return false;
        }
        if (other.getSupportedOperators() == null ^ this.getSupportedOperators() == null) {
            return false;
        }
        if (other.getSupportedOperators() != null && !other.getSupportedOperators().equals(this.getSupportedOperators())) {
            return false;
        }
        if (other.getSupportedWriteOperations() == null ^ this.getSupportedWriteOperations() == null) {
            return false;
        }
        if (other.getSupportedWriteOperations() != null && !other.getSupportedWriteOperations().equals(this.getSupportedWriteOperations())) {
            return false;
        }
        if (other.getConnectorProvisioningType() == null ^ this.getConnectorProvisioningType() == null) {
            return false;
        }
        if (other.getConnectorProvisioningType() != null && !other.getConnectorProvisioningType().equals(this.getConnectorProvisioningType())) {
            return false;
        }
        if (other.getConnectorProvisioningConfig() == null ^ this.getConnectorProvisioningConfig() == null) {
            return false;
        }
        if (other.getConnectorProvisioningConfig() != null && !other.getConnectorProvisioningConfig().equals(this.getConnectorProvisioningConfig())) {
            return false;
        }
        if (other.getLogoURL() == null ^ this.getLogoURL() == null) {
            return false;
        }
        if (other.getLogoURL() != null && !other.getLogoURL().equals(this.getLogoURL())) {
            return false;
        }
        if (other.getRegisteredAt() == null ^ this.getRegisteredAt() == null) {
            return false;
        }
        if (other.getRegisteredAt() != null && !other.getRegisteredAt().equals(this.getRegisteredAt())) {
            return false;
        }
        if (other.getRegisteredBy() == null ^ this.getRegisteredBy() == null) {
            return false;
        }
        return other.getRegisteredBy() == null || other.getRegisteredBy().equals(this.getRegisteredBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCanUseAsSource() == null ? 0 : this.getCanUseAsSource().hashCode());
        hashCode = 31 * hashCode + (this.getCanUseAsDestination() == null ? 0 : this.getCanUseAsDestination().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedDestinationConnectors() == null ? 0 : this.getSupportedDestinationConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedSchedulingFrequencies() == null ? 0 : this.getSupportedSchedulingFrequencies().hashCode());
        hashCode = 31 * hashCode + (this.getIsPrivateLinkEnabled() == null ? 0 : this.getIsPrivateLinkEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getIsPrivateLinkEndpointUrlRequired() == null ? 0 : this.getIsPrivateLinkEndpointUrlRequired().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTriggerTypes() == null ? 0 : this.getSupportedTriggerTypes().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorMetadata() == null ? 0 : this.getConnectorMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorType() == null ? 0 : this.getConnectorType().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorLabel() == null ? 0 : this.getConnectorLabel().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorDescription() == null ? 0 : this.getConnectorDescription().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorOwner() == null ? 0 : this.getConnectorOwner().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorName() == null ? 0 : this.getConnectorName().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorVersion() == null ? 0 : this.getConnectorVersion().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorArn() == null ? 0 : this.getConnectorArn().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorModes() == null ? 0 : this.getConnectorModes().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationConfig() == null ? 0 : this.getAuthenticationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorRuntimeSettings() == null ? 0 : this.getConnectorRuntimeSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedApiVersions() == null ? 0 : this.getSupportedApiVersions().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedOperators() == null ? 0 : this.getSupportedOperators().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedWriteOperations() == null ? 0 : this.getSupportedWriteOperations().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorProvisioningType() == null ? 0 : this.getConnectorProvisioningType().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorProvisioningConfig() == null ? 0 : this.getConnectorProvisioningConfig().hashCode());
        hashCode = 31 * hashCode + (this.getLogoURL() == null ? 0 : this.getLogoURL().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredAt() == null ? 0 : this.getRegisteredAt().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredBy() == null ? 0 : this.getRegisteredBy().hashCode());
        return hashCode;
    }

    public ConnectorConfiguration clone() {
        try {
            return (ConnectorConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectorConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

