/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appfabric;

import javax.annotation.Generated;

import com.amazonaws.services.appfabric.model.*;

/**
 * Abstract implementation of {@code AWSAppFabricAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppFabricAsync extends AbstractAWSAppFabric implements AWSAppFabricAsync {

    protected AbstractAWSAppFabricAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchGetUserAccessTasksResult> batchGetUserAccessTasksAsync(BatchGetUserAccessTasksRequest request) {

        return batchGetUserAccessTasksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchGetUserAccessTasksResult> batchGetUserAccessTasksAsync(BatchGetUserAccessTasksRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchGetUserAccessTasksRequest, BatchGetUserAccessTasksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ConnectAppAuthorizationResult> connectAppAuthorizationAsync(ConnectAppAuthorizationRequest request) {

        return connectAppAuthorizationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ConnectAppAuthorizationResult> connectAppAuthorizationAsync(ConnectAppAuthorizationRequest request,
            com.amazonaws.handlers.AsyncHandler<ConnectAppAuthorizationRequest, ConnectAppAuthorizationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAppAuthorizationResult> createAppAuthorizationAsync(CreateAppAuthorizationRequest request) {

        return createAppAuthorizationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAppAuthorizationResult> createAppAuthorizationAsync(CreateAppAuthorizationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAppAuthorizationRequest, CreateAppAuthorizationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAppBundleResult> createAppBundleAsync(CreateAppBundleRequest request) {

        return createAppBundleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAppBundleResult> createAppBundleAsync(CreateAppBundleRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAppBundleRequest, CreateAppBundleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateIngestionResult> createIngestionAsync(CreateIngestionRequest request) {

        return createIngestionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateIngestionResult> createIngestionAsync(CreateIngestionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateIngestionRequest, CreateIngestionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateIngestionDestinationResult> createIngestionDestinationAsync(CreateIngestionDestinationRequest request) {

        return createIngestionDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateIngestionDestinationResult> createIngestionDestinationAsync(CreateIngestionDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateIngestionDestinationRequest, CreateIngestionDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAppAuthorizationResult> deleteAppAuthorizationAsync(DeleteAppAuthorizationRequest request) {

        return deleteAppAuthorizationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAppAuthorizationResult> deleteAppAuthorizationAsync(DeleteAppAuthorizationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAppAuthorizationRequest, DeleteAppAuthorizationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAppBundleResult> deleteAppBundleAsync(DeleteAppBundleRequest request) {

        return deleteAppBundleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAppBundleResult> deleteAppBundleAsync(DeleteAppBundleRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAppBundleRequest, DeleteAppBundleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIngestionResult> deleteIngestionAsync(DeleteIngestionRequest request) {

        return deleteIngestionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIngestionResult> deleteIngestionAsync(DeleteIngestionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIngestionRequest, DeleteIngestionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIngestionDestinationResult> deleteIngestionDestinationAsync(DeleteIngestionDestinationRequest request) {

        return deleteIngestionDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIngestionDestinationResult> deleteIngestionDestinationAsync(DeleteIngestionDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIngestionDestinationRequest, DeleteIngestionDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAppAuthorizationResult> getAppAuthorizationAsync(GetAppAuthorizationRequest request) {

        return getAppAuthorizationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAppAuthorizationResult> getAppAuthorizationAsync(GetAppAuthorizationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAppAuthorizationRequest, GetAppAuthorizationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAppBundleResult> getAppBundleAsync(GetAppBundleRequest request) {

        return getAppBundleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAppBundleResult> getAppBundleAsync(GetAppBundleRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAppBundleRequest, GetAppBundleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIngestionResult> getIngestionAsync(GetIngestionRequest request) {

        return getIngestionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIngestionResult> getIngestionAsync(GetIngestionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIngestionRequest, GetIngestionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIngestionDestinationResult> getIngestionDestinationAsync(GetIngestionDestinationRequest request) {

        return getIngestionDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIngestionDestinationResult> getIngestionDestinationAsync(GetIngestionDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIngestionDestinationRequest, GetIngestionDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAppAuthorizationsResult> listAppAuthorizationsAsync(ListAppAuthorizationsRequest request) {

        return listAppAuthorizationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAppAuthorizationsResult> listAppAuthorizationsAsync(ListAppAuthorizationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAppAuthorizationsRequest, ListAppAuthorizationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAppBundlesResult> listAppBundlesAsync(ListAppBundlesRequest request) {

        return listAppBundlesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAppBundlesResult> listAppBundlesAsync(ListAppBundlesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAppBundlesRequest, ListAppBundlesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIngestionDestinationsResult> listIngestionDestinationsAsync(ListIngestionDestinationsRequest request) {

        return listIngestionDestinationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIngestionDestinationsResult> listIngestionDestinationsAsync(ListIngestionDestinationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIngestionDestinationsRequest, ListIngestionDestinationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIngestionsResult> listIngestionsAsync(ListIngestionsRequest request) {

        return listIngestionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIngestionsResult> listIngestionsAsync(ListIngestionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIngestionsRequest, ListIngestionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartIngestionResult> startIngestionAsync(StartIngestionRequest request) {

        return startIngestionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartIngestionResult> startIngestionAsync(StartIngestionRequest request,
            com.amazonaws.handlers.AsyncHandler<StartIngestionRequest, StartIngestionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartUserAccessTasksResult> startUserAccessTasksAsync(StartUserAccessTasksRequest request) {

        return startUserAccessTasksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartUserAccessTasksResult> startUserAccessTasksAsync(StartUserAccessTasksRequest request,
            com.amazonaws.handlers.AsyncHandler<StartUserAccessTasksRequest, StartUserAccessTasksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopIngestionResult> stopIngestionAsync(StopIngestionRequest request) {

        return stopIngestionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopIngestionResult> stopIngestionAsync(StopIngestionRequest request,
            com.amazonaws.handlers.AsyncHandler<StopIngestionRequest, StopIngestionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAppAuthorizationResult> updateAppAuthorizationAsync(UpdateAppAuthorizationRequest request) {

        return updateAppAuthorizationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAppAuthorizationResult> updateAppAuthorizationAsync(UpdateAppAuthorizationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAppAuthorizationRequest, UpdateAppAuthorizationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateIngestionDestinationResult> updateIngestionDestinationAsync(UpdateIngestionDestinationRequest request) {

        return updateIngestionDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateIngestionDestinationResult> updateIngestionDestinationAsync(UpdateIngestionDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateIngestionDestinationRequest, UpdateIngestionDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
