/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfig.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appconfig.model.DeploymentEvent;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DeploymentEventMarshaller {
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventType").build();
    private static final MarshallingInfo<String> TRIGGEREDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TriggeredBy").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> ACTIONINVOCATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionInvocations").build();
    private static final MarshallingInfo<Date> OCCURREDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OccurredAt").timestampFormat("iso8601").build();
    private static final DeploymentEventMarshaller instance = new DeploymentEventMarshaller();

    public static DeploymentEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeploymentEvent deploymentEvent, ProtocolMarshaller protocolMarshaller) {
        if (deploymentEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deploymentEvent.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)deploymentEvent.getTriggeredBy(), TRIGGEREDBY_BINDING);
            protocolMarshaller.marshall((Object)deploymentEvent.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(deploymentEvent.getActionInvocations(), ACTIONINVOCATIONS_BINDING);
            protocolMarshaller.marshall((Object)deploymentEvent.getOccurredAt(), OCCURREDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

