/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfig.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appconfig.model.Action;
import com.amazonaws.services.appconfig.model.Parameter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateExtensionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private Map<String, List<Action>> actions;
    private Map<String, Parameter> parameters;
    private Map<String, String> tags;
    private Integer latestVersionNumber;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateExtensionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateExtensionRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, List<Action>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, List<Action>> actions) {
        this.actions = actions;
    }

    public CreateExtensionRequest withActions(Map<String, List<Action>> actions) {
        this.setActions(actions);
        return this;
    }

    public CreateExtensionRequest addActionsEntry(String key, List<Action> value) {
        if (null == this.actions) {
            this.actions = new HashMap<String, List<Action>>();
        }
        if (this.actions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.actions.put(key, value);
        return this;
    }

    public CreateExtensionRequest clearActionsEntries() {
        this.actions = null;
        return this;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public CreateExtensionRequest withParameters(Map<String, Parameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public CreateExtensionRequest addParametersEntry(String key, Parameter value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, Parameter>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public CreateExtensionRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateExtensionRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateExtensionRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateExtensionRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setLatestVersionNumber(Integer latestVersionNumber) {
        this.latestVersionNumber = latestVersionNumber;
    }

    public Integer getLatestVersionNumber() {
        return this.latestVersionNumber;
    }

    public CreateExtensionRequest withLatestVersionNumber(Integer latestVersionNumber) {
        this.setLatestVersionNumber(latestVersionNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getLatestVersionNumber() != null) {
            sb.append("LatestVersionNumber: ").append(this.getLatestVersionNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExtensionRequest)) {
            return false;
        }
        CreateExtensionRequest other = (CreateExtensionRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getLatestVersionNumber() == null ^ this.getLatestVersionNumber() == null) {
            return false;
        }
        return other.getLatestVersionNumber() == null || other.getLatestVersionNumber().equals(this.getLatestVersionNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getLatestVersionNumber() == null ? 0 : this.getLatestVersionNumber().hashCode());
        return hashCode;
    }

    public CreateExtensionRequest clone() {
        return (CreateExtensionRequest)super.clone();
    }
}

