/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfig.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appconfig.model.DeploymentSummary;
import java.util.Date;

@SdkInternalApi
public class DeploymentSummaryMarshaller {
    private static final MarshallingInfo<Integer> DEPLOYMENTNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentNumber").build();
    private static final MarshallingInfo<String> CONFIGURATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationName").build();
    private static final MarshallingInfo<String> CONFIGURATIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationVersion").build();
    private static final MarshallingInfo<Integer> DEPLOYMENTDURATIONINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentDurationInMinutes").build();
    private static final MarshallingInfo<String> GROWTHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrowthType").build();
    private static final MarshallingInfo<Float> GROWTHFACTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrowthFactor").build();
    private static final MarshallingInfo<Integer> FINALBAKETIMEINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinalBakeTimeInMinutes").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Float> PERCENTAGECOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PercentageComplete").build();
    private static final MarshallingInfo<Date> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> COMPLETEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> VERSIONLABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionLabel").build();
    private static final DeploymentSummaryMarshaller instance = new DeploymentSummaryMarshaller();

    public static DeploymentSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeploymentSummary deploymentSummary, ProtocolMarshaller protocolMarshaller) {
        if (deploymentSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deploymentSummary.getDeploymentNumber(), DEPLOYMENTNUMBER_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getConfigurationName(), CONFIGURATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getConfigurationVersion(), CONFIGURATIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getDeploymentDurationInMinutes(), DEPLOYMENTDURATIONINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getGrowthType(), GROWTHTYPE_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getGrowthFactor(), GROWTHFACTOR_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getFinalBakeTimeInMinutes(), FINALBAKETIMEINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getPercentageComplete(), PERCENTAGECOMPLETE_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getStartedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getCompletedAt(), COMPLETEDAT_BINDING);
            protocolMarshaller.marshall((Object)deploymentSummary.getVersionLabel(), VERSIONLABEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

