/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewayv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigatewayv2.model.VpcLinkStatus;
import com.amazonaws.services.apigatewayv2.model.VpcLinkVersion;
import com.amazonaws.services.apigatewayv2.model.transform.VpcLinkMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VpcLink
implements Serializable,
Cloneable,
StructuredPojo {
    private Date createdDate;
    private String name;
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    private Map<String, String> tags;
    private String vpcLinkId;
    private String vpcLinkStatus;
    private String vpcLinkStatusMessage;
    private String vpcLinkVersion;

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public VpcLink withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VpcLink withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public VpcLink withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public VpcLink withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public VpcLink withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public VpcLink withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public VpcLink withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public VpcLink addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public VpcLink clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setVpcLinkId(String vpcLinkId) {
        this.vpcLinkId = vpcLinkId;
    }

    public String getVpcLinkId() {
        return this.vpcLinkId;
    }

    public VpcLink withVpcLinkId(String vpcLinkId) {
        this.setVpcLinkId(vpcLinkId);
        return this;
    }

    public void setVpcLinkStatus(String vpcLinkStatus) {
        this.vpcLinkStatus = vpcLinkStatus;
    }

    public String getVpcLinkStatus() {
        return this.vpcLinkStatus;
    }

    public VpcLink withVpcLinkStatus(String vpcLinkStatus) {
        this.setVpcLinkStatus(vpcLinkStatus);
        return this;
    }

    public VpcLink withVpcLinkStatus(VpcLinkStatus vpcLinkStatus) {
        this.vpcLinkStatus = vpcLinkStatus.toString();
        return this;
    }

    public void setVpcLinkStatusMessage(String vpcLinkStatusMessage) {
        this.vpcLinkStatusMessage = vpcLinkStatusMessage;
    }

    public String getVpcLinkStatusMessage() {
        return this.vpcLinkStatusMessage;
    }

    public VpcLink withVpcLinkStatusMessage(String vpcLinkStatusMessage) {
        this.setVpcLinkStatusMessage(vpcLinkStatusMessage);
        return this;
    }

    public void setVpcLinkVersion(String vpcLinkVersion) {
        this.vpcLinkVersion = vpcLinkVersion;
    }

    public String getVpcLinkVersion() {
        return this.vpcLinkVersion;
    }

    public VpcLink withVpcLinkVersion(String vpcLinkVersion) {
        this.setVpcLinkVersion(vpcLinkVersion);
        return this;
    }

    public VpcLink withVpcLinkVersion(VpcLinkVersion vpcLinkVersion) {
        this.vpcLinkVersion = vpcLinkVersion.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcLinkId() != null) {
            sb.append("VpcLinkId: ").append(this.getVpcLinkId()).append(",");
        }
        if (this.getVpcLinkStatus() != null) {
            sb.append("VpcLinkStatus: ").append(this.getVpcLinkStatus()).append(",");
        }
        if (this.getVpcLinkStatusMessage() != null) {
            sb.append("VpcLinkStatusMessage: ").append(this.getVpcLinkStatusMessage()).append(",");
        }
        if (this.getVpcLinkVersion() != null) {
            sb.append("VpcLinkVersion: ").append(this.getVpcLinkVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcLink)) {
            return false;
        }
        VpcLink other = (VpcLink)obj;
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcLinkId() == null ^ this.getVpcLinkId() == null) {
            return false;
        }
        if (other.getVpcLinkId() != null && !other.getVpcLinkId().equals(this.getVpcLinkId())) {
            return false;
        }
        if (other.getVpcLinkStatus() == null ^ this.getVpcLinkStatus() == null) {
            return false;
        }
        if (other.getVpcLinkStatus() != null && !other.getVpcLinkStatus().equals(this.getVpcLinkStatus())) {
            return false;
        }
        if (other.getVpcLinkStatusMessage() == null ^ this.getVpcLinkStatusMessage() == null) {
            return false;
        }
        if (other.getVpcLinkStatusMessage() != null && !other.getVpcLinkStatusMessage().equals(this.getVpcLinkStatusMessage())) {
            return false;
        }
        if (other.getVpcLinkVersion() == null ^ this.getVpcLinkVersion() == null) {
            return false;
        }
        return other.getVpcLinkVersion() == null || other.getVpcLinkVersion().equals(this.getVpcLinkVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcLinkId() == null ? 0 : this.getVpcLinkId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcLinkStatus() == null ? 0 : this.getVpcLinkStatus().hashCode());
        hashCode = 31 * hashCode + (this.getVpcLinkStatusMessage() == null ? 0 : this.getVpcLinkStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getVpcLinkVersion() == null ? 0 : this.getVpcLinkVersion().hashCode());
        return hashCode;
    }

    public VpcLink clone() {
        try {
            return (VpcLink)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VpcLinkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

