/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplify.model.Stage;
import com.amazonaws.services.amplify.model.transform.AutoBranchCreationConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AutoBranchCreationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String stage;
    private String framework;
    private Boolean enableAutoBuild;
    private Map<String, String> environmentVariables;
    private String basicAuthCredentials;
    private Boolean enableBasicAuth;
    private String buildSpec;

    public void setStage(String stage) {
        this.stage = stage;
    }

    public String getStage() {
        return this.stage;
    }

    public AutoBranchCreationConfig withStage(String stage) {
        this.setStage(stage);
        return this;
    }

    public AutoBranchCreationConfig withStage(Stage stage) {
        this.stage = stage.toString();
        return this;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public String getFramework() {
        return this.framework;
    }

    public AutoBranchCreationConfig withFramework(String framework) {
        this.setFramework(framework);
        return this;
    }

    public void setEnableAutoBuild(Boolean enableAutoBuild) {
        this.enableAutoBuild = enableAutoBuild;
    }

    public Boolean getEnableAutoBuild() {
        return this.enableAutoBuild;
    }

    public AutoBranchCreationConfig withEnableAutoBuild(Boolean enableAutoBuild) {
        this.setEnableAutoBuild(enableAutoBuild);
        return this;
    }

    public Boolean isEnableAutoBuild() {
        return this.enableAutoBuild;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public AutoBranchCreationConfig withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.setEnvironmentVariables(environmentVariables);
        return this;
    }

    public AutoBranchCreationConfig addEnvironmentVariablesEntry(String key, String value) {
        if (null == this.environmentVariables) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (this.environmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environmentVariables.put(key, value);
        return this;
    }

    public AutoBranchCreationConfig clearEnvironmentVariablesEntries() {
        this.environmentVariables = null;
        return this;
    }

    public void setBasicAuthCredentials(String basicAuthCredentials) {
        this.basicAuthCredentials = basicAuthCredentials;
    }

    public String getBasicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public AutoBranchCreationConfig withBasicAuthCredentials(String basicAuthCredentials) {
        this.setBasicAuthCredentials(basicAuthCredentials);
        return this;
    }

    public void setEnableBasicAuth(Boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public Boolean getEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public AutoBranchCreationConfig withEnableBasicAuth(Boolean enableBasicAuth) {
        this.setEnableBasicAuth(enableBasicAuth);
        return this;
    }

    public Boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setBuildSpec(String buildSpec) {
        this.buildSpec = buildSpec;
    }

    public String getBuildSpec() {
        return this.buildSpec;
    }

    public AutoBranchCreationConfig withBuildSpec(String buildSpec) {
        this.setBuildSpec(buildSpec);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStage() != null) {
            sb.append("Stage: ").append(this.getStage()).append(",");
        }
        if (this.getFramework() != null) {
            sb.append("Framework: ").append(this.getFramework()).append(",");
        }
        if (this.getEnableAutoBuild() != null) {
            sb.append("EnableAutoBuild: ").append(this.getEnableAutoBuild()).append(",");
        }
        if (this.getEnvironmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.getEnvironmentVariables()).append(",");
        }
        if (this.getBasicAuthCredentials() != null) {
            sb.append("BasicAuthCredentials: ").append(this.getBasicAuthCredentials()).append(",");
        }
        if (this.getEnableBasicAuth() != null) {
            sb.append("EnableBasicAuth: ").append(this.getEnableBasicAuth()).append(",");
        }
        if (this.getBuildSpec() != null) {
            sb.append("BuildSpec: ").append(this.getBuildSpec());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoBranchCreationConfig)) {
            return false;
        }
        AutoBranchCreationConfig other = (AutoBranchCreationConfig)obj;
        if (other.getStage() == null ^ this.getStage() == null) {
            return false;
        }
        if (other.getStage() != null && !other.getStage().equals(this.getStage())) {
            return false;
        }
        if (other.getFramework() == null ^ this.getFramework() == null) {
            return false;
        }
        if (other.getFramework() != null && !other.getFramework().equals(this.getFramework())) {
            return false;
        }
        if (other.getEnableAutoBuild() == null ^ this.getEnableAutoBuild() == null) {
            return false;
        }
        if (other.getEnableAutoBuild() != null && !other.getEnableAutoBuild().equals(this.getEnableAutoBuild())) {
            return false;
        }
        if (other.getEnvironmentVariables() == null ^ this.getEnvironmentVariables() == null) {
            return false;
        }
        if (other.getEnvironmentVariables() != null && !other.getEnvironmentVariables().equals(this.getEnvironmentVariables())) {
            return false;
        }
        if (other.getBasicAuthCredentials() == null ^ this.getBasicAuthCredentials() == null) {
            return false;
        }
        if (other.getBasicAuthCredentials() != null && !other.getBasicAuthCredentials().equals(this.getBasicAuthCredentials())) {
            return false;
        }
        if (other.getEnableBasicAuth() == null ^ this.getEnableBasicAuth() == null) {
            return false;
        }
        if (other.getEnableBasicAuth() != null && !other.getEnableBasicAuth().equals(this.getEnableBasicAuth())) {
            return false;
        }
        if (other.getBuildSpec() == null ^ this.getBuildSpec() == null) {
            return false;
        }
        return other.getBuildSpec() == null || other.getBuildSpec().equals(this.getBuildSpec());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStage() == null ? 0 : this.getStage().hashCode());
        hashCode = 31 * hashCode + (this.getFramework() == null ? 0 : this.getFramework().hashCode());
        hashCode = 31 * hashCode + (this.getEnableAutoBuild() == null ? 0 : this.getEnableAutoBuild().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentVariables() == null ? 0 : this.getEnvironmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.getBasicAuthCredentials() == null ? 0 : this.getBasicAuthCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getEnableBasicAuth() == null ? 0 : this.getEnableBasicAuth().hashCode());
        hashCode = 31 * hashCode + (this.getBuildSpec() == null ? 0 : this.getBuildSpec().hashCode());
        return hashCode;
    }

    public AutoBranchCreationConfig clone() {
        try {
            return (AutoBranchCreationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoBranchCreationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

