/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.alexaforbusiness.model.NetworkEapMethod;
import com.amazonaws.services.alexaforbusiness.model.NetworkSecurityType;
import com.amazonaws.services.alexaforbusiness.model.transform.NetworkProfileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkProfile
implements Serializable,
Cloneable,
StructuredPojo {
    private String networkProfileArn;
    private String networkProfileName;
    private String description;
    private String ssid;
    private String securityType;
    private String eapMethod;
    private String currentPassword;
    private String nextPassword;
    private String certificateAuthorityArn;
    private List<String> trustAnchors;

    public void setNetworkProfileArn(String networkProfileArn) {
        this.networkProfileArn = networkProfileArn;
    }

    public String getNetworkProfileArn() {
        return this.networkProfileArn;
    }

    public NetworkProfile withNetworkProfileArn(String networkProfileArn) {
        this.setNetworkProfileArn(networkProfileArn);
        return this;
    }

    public void setNetworkProfileName(String networkProfileName) {
        this.networkProfileName = networkProfileName;
    }

    public String getNetworkProfileName() {
        return this.networkProfileName;
    }

    public NetworkProfile withNetworkProfileName(String networkProfileName) {
        this.setNetworkProfileName(networkProfileName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public NetworkProfile withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSsid(String ssid) {
        this.ssid = ssid;
    }

    public String getSsid() {
        return this.ssid;
    }

    public NetworkProfile withSsid(String ssid) {
        this.setSsid(ssid);
        return this;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public NetworkProfile withSecurityType(String securityType) {
        this.setSecurityType(securityType);
        return this;
    }

    public NetworkProfile withSecurityType(NetworkSecurityType securityType) {
        this.securityType = securityType.toString();
        return this;
    }

    public void setEapMethod(String eapMethod) {
        this.eapMethod = eapMethod;
    }

    public String getEapMethod() {
        return this.eapMethod;
    }

    public NetworkProfile withEapMethod(String eapMethod) {
        this.setEapMethod(eapMethod);
        return this;
    }

    public NetworkProfile withEapMethod(NetworkEapMethod eapMethod) {
        this.eapMethod = eapMethod.toString();
        return this;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public NetworkProfile withCurrentPassword(String currentPassword) {
        this.setCurrentPassword(currentPassword);
        return this;
    }

    public void setNextPassword(String nextPassword) {
        this.nextPassword = nextPassword;
    }

    public String getNextPassword() {
        return this.nextPassword;
    }

    public NetworkProfile withNextPassword(String nextPassword) {
        this.setNextPassword(nextPassword);
        return this;
    }

    public void setCertificateAuthorityArn(String certificateAuthorityArn) {
        this.certificateAuthorityArn = certificateAuthorityArn;
    }

    public String getCertificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public NetworkProfile withCertificateAuthorityArn(String certificateAuthorityArn) {
        this.setCertificateAuthorityArn(certificateAuthorityArn);
        return this;
    }

    public List<String> getTrustAnchors() {
        return this.trustAnchors;
    }

    public void setTrustAnchors(Collection<String> trustAnchors) {
        if (trustAnchors == null) {
            this.trustAnchors = null;
            return;
        }
        this.trustAnchors = new ArrayList<String>(trustAnchors);
    }

    public NetworkProfile withTrustAnchors(String ... trustAnchors) {
        if (this.trustAnchors == null) {
            this.setTrustAnchors(new ArrayList<String>(trustAnchors.length));
        }
        for (String ele : trustAnchors) {
            this.trustAnchors.add(ele);
        }
        return this;
    }

    public NetworkProfile withTrustAnchors(Collection<String> trustAnchors) {
        this.setTrustAnchors(trustAnchors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkProfileArn() != null) {
            sb.append("NetworkProfileArn: ").append(this.getNetworkProfileArn()).append(",");
        }
        if (this.getNetworkProfileName() != null) {
            sb.append("NetworkProfileName: ").append(this.getNetworkProfileName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSsid() != null) {
            sb.append("Ssid: ").append(this.getSsid()).append(",");
        }
        if (this.getSecurityType() != null) {
            sb.append("SecurityType: ").append(this.getSecurityType()).append(",");
        }
        if (this.getEapMethod() != null) {
            sb.append("EapMethod: ").append(this.getEapMethod()).append(",");
        }
        if (this.getCurrentPassword() != null) {
            sb.append("CurrentPassword: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getNextPassword() != null) {
            sb.append("NextPassword: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCertificateAuthorityArn() != null) {
            sb.append("CertificateAuthorityArn: ").append(this.getCertificateAuthorityArn()).append(",");
        }
        if (this.getTrustAnchors() != null) {
            sb.append("TrustAnchors: ").append(this.getTrustAnchors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkProfile)) {
            return false;
        }
        NetworkProfile other = (NetworkProfile)obj;
        if (other.getNetworkProfileArn() == null ^ this.getNetworkProfileArn() == null) {
            return false;
        }
        if (other.getNetworkProfileArn() != null && !other.getNetworkProfileArn().equals(this.getNetworkProfileArn())) {
            return false;
        }
        if (other.getNetworkProfileName() == null ^ this.getNetworkProfileName() == null) {
            return false;
        }
        if (other.getNetworkProfileName() != null && !other.getNetworkProfileName().equals(this.getNetworkProfileName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSsid() == null ^ this.getSsid() == null) {
            return false;
        }
        if (other.getSsid() != null && !other.getSsid().equals(this.getSsid())) {
            return false;
        }
        if (other.getSecurityType() == null ^ this.getSecurityType() == null) {
            return false;
        }
        if (other.getSecurityType() != null && !other.getSecurityType().equals(this.getSecurityType())) {
            return false;
        }
        if (other.getEapMethod() == null ^ this.getEapMethod() == null) {
            return false;
        }
        if (other.getEapMethod() != null && !other.getEapMethod().equals(this.getEapMethod())) {
            return false;
        }
        if (other.getCurrentPassword() == null ^ this.getCurrentPassword() == null) {
            return false;
        }
        if (other.getCurrentPassword() != null && !other.getCurrentPassword().equals(this.getCurrentPassword())) {
            return false;
        }
        if (other.getNextPassword() == null ^ this.getNextPassword() == null) {
            return false;
        }
        if (other.getNextPassword() != null && !other.getNextPassword().equals(this.getNextPassword())) {
            return false;
        }
        if (other.getCertificateAuthorityArn() == null ^ this.getCertificateAuthorityArn() == null) {
            return false;
        }
        if (other.getCertificateAuthorityArn() != null && !other.getCertificateAuthorityArn().equals(this.getCertificateAuthorityArn())) {
            return false;
        }
        if (other.getTrustAnchors() == null ^ this.getTrustAnchors() == null) {
            return false;
        }
        return other.getTrustAnchors() == null || other.getTrustAnchors().equals(this.getTrustAnchors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkProfileArn() == null ? 0 : this.getNetworkProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkProfileName() == null ? 0 : this.getNetworkProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSsid() == null ? 0 : this.getSsid().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityType() == null ? 0 : this.getSecurityType().hashCode());
        hashCode = 31 * hashCode + (this.getEapMethod() == null ? 0 : this.getEapMethod().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPassword() == null ? 0 : this.getCurrentPassword().hashCode());
        hashCode = 31 * hashCode + (this.getNextPassword() == null ? 0 : this.getNextPassword().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateAuthorityArn() == null ? 0 : this.getCertificateAuthorityArn().hashCode());
        hashCode = 31 * hashCode + (this.getTrustAnchors() == null ? 0 : this.getTrustAnchors().hashCode());
        return hashCode;
    }

    public NetworkProfile clone() {
        try {
            return (NetworkProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

