/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.acmpca.model.AccessDescription;
import com.amazonaws.services.acmpca.model.KeyUsage;
import com.amazonaws.services.acmpca.model.transform.CsrExtensionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CsrExtensions
implements Serializable,
Cloneable,
StructuredPojo {
    private KeyUsage keyUsage;
    private List<AccessDescription> subjectInformationAccess;

    public void setKeyUsage(KeyUsage keyUsage) {
        this.keyUsage = keyUsage;
    }

    public KeyUsage getKeyUsage() {
        return this.keyUsage;
    }

    public CsrExtensions withKeyUsage(KeyUsage keyUsage) {
        this.setKeyUsage(keyUsage);
        return this;
    }

    public List<AccessDescription> getSubjectInformationAccess() {
        return this.subjectInformationAccess;
    }

    public void setSubjectInformationAccess(Collection<AccessDescription> subjectInformationAccess) {
        if (subjectInformationAccess == null) {
            this.subjectInformationAccess = null;
            return;
        }
        this.subjectInformationAccess = new ArrayList<AccessDescription>(subjectInformationAccess);
    }

    public CsrExtensions withSubjectInformationAccess(AccessDescription ... subjectInformationAccess) {
        if (this.subjectInformationAccess == null) {
            this.setSubjectInformationAccess(new ArrayList<AccessDescription>(subjectInformationAccess.length));
        }
        for (AccessDescription ele : subjectInformationAccess) {
            this.subjectInformationAccess.add(ele);
        }
        return this;
    }

    public CsrExtensions withSubjectInformationAccess(Collection<AccessDescription> subjectInformationAccess) {
        this.setSubjectInformationAccess(subjectInformationAccess);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyUsage() != null) {
            sb.append("KeyUsage: ").append(this.getKeyUsage()).append(",");
        }
        if (this.getSubjectInformationAccess() != null) {
            sb.append("SubjectInformationAccess: ").append(this.getSubjectInformationAccess());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsrExtensions)) {
            return false;
        }
        CsrExtensions other = (CsrExtensions)obj;
        if (other.getKeyUsage() == null ^ this.getKeyUsage() == null) {
            return false;
        }
        if (other.getKeyUsage() != null && !other.getKeyUsage().equals(this.getKeyUsage())) {
            return false;
        }
        if (other.getSubjectInformationAccess() == null ^ this.getSubjectInformationAccess() == null) {
            return false;
        }
        return other.getSubjectInformationAccess() == null || other.getSubjectInformationAccess().equals(this.getSubjectInformationAccess());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyUsage() == null ? 0 : this.getKeyUsage().hashCode());
        hashCode = 31 * hashCode + (this.getSubjectInformationAccess() == null ? 0 : this.getSubjectInformationAccess().hashCode());
        return hashCode;
    }

    public CsrExtensions clone() {
        try {
            return (CsrExtensions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CsrExtensionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

